<?php
    include "../../utils/Database.php";
    include "../../utils/functions.php";
    include "../../models/Slider.php";
    include "../../models/Image.php";
    include "../../services/SliderService.php";
    include "../../services/ImageService.php";
?>

<?php

    $database = new Database();
    $db = $database->connect();

    $slider_service = new SliderService($db);
    $image_service = new ImageService($db);

    switch($action) {
        case 'edit':
            if (isset($_POST['edit'])) {

                if ($_FILES['fileToUpload']['name'] == "") {
                    $get_image = $image_service->get($_POST['oldImage']);
                    $image = new Image(
                        $get_image['id'],
                        $get_image['caption'],
                        $get_image['filename']
                    );

                    $slider = new Slider(
                        $_GET['id'],
                        $_POST['title'],
                        $_POST['subheading'],
                        $image->id
                    );
                    $result = $slider_service->update($post);
                    if($result){
                        set_notification("Slide edited", "success");
                    } else {
                        set_notification("Some error occurred", "error");
                    }
                } else {
                    $new_image = new Image(0, $_POST['title'], $_FILES['fileToUpload']['name']);
                    $image_service->add($new_image);
                    
                    $result_list = $image_service->getLatest();
                    foreach($result_list as $result) {
                        $image = new Image(
                            $result['id'],
                            $result['caption'],
                            $result['filename']
                        );
                    }

                    $slider = new Slider(
                        $_GET['id'],
                        $_POST['title'],
                        $_POST['subheading'],
                        $image->id
                    );

                    if (upload_file($_FILES, 'images')) {
                        $result = $slider_service->update($slider);
                        if($result){
                            set_notification("Slide edited", "success");
                        } else {
                            set_notification("Some error occurred", "error");
                        }
                    }
                }
            } else {
                
                $result = $slider_service->get($_GET['id']);

                $slider = new Slider(
                    $result['id'],
                    $result['title'],
                    $result['subheading'],
                    $result['image']
                );

                $object = $image_service->get($slider->image);
                $image = new Image(
                    $object['id'],
                    $object['caption'],
                    $object['filename']
                );
            }
            break;
        case 'list':
            $result_list = $slider_service->list();
            
            $sliders = array();
            
            foreach($result_list as $result) {
                $slider = new Slider(
                    $result['id'],
                    $result['title'],
                    $result['subheading'],
                    $result['image']
                );
                array_push($sliders, $slider);
            }

            break;
        default:
            continue;
    }
?>