<?php
    include "../../utils/Database.php";
    include "../../utils/functions.php";
    include "../../models/User.php";
    include "../../services/UserService.php";
?>

<?php

    $database = new Database();
    $db = $database->connect();

    $user_service = new UserService($db);

    if (isset($_POST['delete'])) {
        $action = 'delete';
    }

    switch($action) {
        case 'login':

            if (isset($_POST['login'])) {
                $object = $user_service->getByUsernameAndPassword($_POST['username'], $_POST['password']);

                if ($object) {

                    $_SESSION['username'] = $object['username'];
                    $_SESSION['name'] = $object['name'];
                    $_SESSION['password'] = $object['password'];
                    $_SESSION['access_level'] = $object['access_level'];
                    
                    set_notification("Welcome " . $_POST['username'], "success");

                    redirect("../dashboard/");
                } else {
                    set_notification("Incorrect username/password", "error");
                }
            }
            break;
        case 'add':
            if(isset($_POST['add'])){
                $user = new User(
                    0,
                    $_POST['name'],
                    $_POST['username'],
                    $_POST['password'],
                    $_POST['email'],
                    $_POST['access_level']
                );
                
                $result = $user_service->add($user);
                if($result){
                    set_notification("New user added", "success");
                } else {
                    set_notification("Some error occurred", "error");
                }
                redirect("../user");
            }
            break;
        case 'edit':
            if (isset($_POST['edit'])) {
                $user = new User(
                    $_GET['id'],
                    $_POST['name'],
                    $_POST['username'],
                    $_POST['password'],
                    $_POST['email'],
                    $_POST['access_level']
                );

                $result = $user_service->update($user);
                if($result){
                    set_notification("User successfully edited", "success");
                } else {
                    set_notification("Some error occurred", "error");
                }
            } else {

                $result = $user_service->get($_GET['id']);
                $user = new User(
                    $result['id'],
                    $result['name'],
                    $result['username'],
                    $result['password'],
                    $result['email'],
                    $result['access_level']
                );
            }
            break;
        case 'list':
            $result_list = $user_service->list();
            
            $users = array();
            
            foreach($result_list as $result) {
                $user = new User(
                    $result['id'],
                    $result['name'],
                    $result['username'],
                    $result['password'],
                    $result['email'],
                    $result['access_level']
                );
                array_push($users, $user);
            }

            break;
        case 'delete':
            $object = $user_service->get($_POST['deleteId']);
            
            $user = new User(
                $object['id'],
                $object['name'],
                $object['username'],
                $object['password'],
                $object['email'],
                $object['access_level']
            );
            if ($user) {
                $result = $user_service->delete($user);
                if($result){
                    set_notification("User successfully deleted", "success");
                } else {
                    set_notification("Some error occurred", "error");
                }
            }
            redirect("user");
            break;
        case 'view':
            $object = $user_service->get($_GET['id']);
            
            $user = new User(
                $object['id'],
                $object['name'],
                $object['username'],
                $object['password'],
                $object['email'],
                $object['access_level']
            );
            break;
        default:
            continue;
    }
?>