<?php

class UserService {

    private $conn;
    private $table = "user";
    
    public function __construct($db) {
        $this->conn = $db;
    }

    public function add($user) {

        $query = "INSERT INTO " . $this->table . 
            " SET name = :name,
                username = :username,
                password = :password, 
                email = :email, 
                access_level = :access_level";
        
        $stmt = $this->conn->prepare($query);
        
        $user->name = htmlspecialchars(strip_tags($user->name));
        $user->username = htmlspecialchars(strip_tags($user->username));
        $user->password = htmlspecialchars(strip_tags($user->password));
        $user->email = htmlspecialchars(strip_tags($user->email));
        $user->access_level = htmlspecialchars(strip_tags($user->access_level));
        
        $user->password = hash('sha256', $user->password);
        
        $stmt->bindParam(':name', $user->name);
        $stmt->bindParam(':username', $user->username);
        $stmt->bindParam(':password', $user->password);
        $stmt->bindParam(':email', $user->email);
        $stmt->bindParam(':access_level', $user->access_level);

        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function update($user) {

        $query = "UPDATE " . $this->table . 
            " SET name = :name,
                username = :username, 
                email = :email,
                access_level = :access_level
              WHERE id = :id";
        
        $stmt = $this->conn->prepare($query);
        
        $user->username = htmlspecialchars(strip_tags($user->username));
        $user->name = htmlspecialchars(strip_tags($user->name));
        $user->email = htmlspecialchars(strip_tags($user->email));
        $user->access_level = htmlspecialchars(strip_tags($user->access_level));
        
        $stmt->bindParam(':username', $user->username);
        $stmt->bindParam(':name', $user->name);
        $stmt->bindParam(':email', $user->email);
        $stmt->bindParam(':access_level', $user->access_level);
        $stmt->bindParam(':id', $user->id);

        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function delete($user) {

        $query = "DELETE FROM " . $this->table . " WHERE id = :id";

        $stmt = $this->conn->prepare($query);
        
        $stmt->bindParam(':id', $user->id);
        
        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function list() {

        $query = "SELECT * FROM " . $this->table . " ORDER BY created_at DESC ";

        $stmt = $this->conn->prepare($query);
        $stmt->execute();

        $result_list = array();

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {       
            array_push($result_list, $row);
        }
        return $result_list;
    }

    public function get($id) {

        $query = "SELECT * FROM " . $this->table . " WHERE id = :id";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();

        return ($stmt->fetch(PDO::FETCH_ASSOC));
    }

    public function getByUsernameAndPassword($username, $password) {
        $query = "SELECT * FROM " . $this->table . " WHERE username = :username AND password = :password";

        $stmt = $this->conn->prepare($query);

        $username = htmlspecialchars(strip_tags($username));
        $password = htmlspecialchars(strip_tags($password));

        $password = hash('sha256', $password);

        $stmt->bindParam(':username', $username);
        $stmt->bindParam(':password', $password);
        
        $stmt->execute();

        return ($stmt->fetch(PDO::FETCH_ASSOC));
    }
}

?>