<?php $page = "Author"; $action="view"; ?>
<?php include "../../routes/author.php"; ?>
<?php include "../layout/header.php"; ?>

<body>
    <?php include "../layout/navbar.php"; ?>
    <div class="container-fluid">
        <div class="row">
            <?php include "../layout/sidenav.php"; ?>

            <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
                <div
                    class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Posts by <?php echo $author->full_name; ?></h1>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped table-sm">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Title</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; 
                            foreach ($posts_by_author as $post) { ?>
                            <tr>
                                <td><?php echo $i++; ?></td>
                                <td><?php echo $post->title; ?></td>
                                <td><?php echo date_format(date_create($post->created_at), "M d, Y"); ?></td>
                                <td>
                                    <a href="view/<?php echo $post->id; ?>" class="btn btn-sm btn-success gsa-text-white" data-toggle="tooltip" data-placement="top" title="View">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="blog/edit/<?php echo $post->id; ?>" class="btn btn-sm btn-info gsa-text-white" data-toggle="tooltip" data-placement="top" title="Edit">
                                        <i class="fas fa-pen"></i>
                                    </a>
                                    <a onclick="deleteModal(<?php echo $post->id; ?>);" class="btn btn-sm btn-danger gsa-text-white" data-toggle="tooltip" data-placement="top" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>
</body>

</html>