<?php $page = "Blog Posts"; $action="add"; ?>
<?php include "../../routes/post.php"; ?>
<?php include "../layout/header.php"; ?>
<body>

    <?php include "../layout/navbar.php"; ?>

    <div class="container-fluid">
      <div class="row">
        <?php include "../layout/sidenav.php"; ?>
        
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Add New <?php echo $page; ?></h1>
            </div>
            <form action="" method="POST" autocomplete="off" enctype="multipart/form-data">
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="title">Title</span>
                    </div>
                    <input type="text" name="title" class="form-control" placeholder="Write the title here" aria-label="Title" aria-describedby="title" required>
                </div>
                <div class="input-group mb-3">
                    <select class="custom-select" name="author" id="author" required>
                        <option selected>Select an author </option>
                        <?php foreach ($authors as $author) { ?>
                            <option value="<?php echo $author->id; ?>">
                                <?php echo $author->full_name; ?>
                            </option>
                        <?php } ?>
                    </select>
                    <div class="custom-file ml-3">
                        <input type="file" name="fileToUpload" class="custom-file-input" id="thumbnail" aria-describedby="thumbnail">
                        <label class="custom-file-label" for="thumbnail">Choose thumbnail</label>
                    </div>    
                </div>
                <div class="input-group mb-3 justify-content-center">
                    <div class="col-6" id="displayThumbnail">

                    </div>
                </div>
                <div class="input-group mb-3">
                    <textarea name="content" class="form-control editor-main" placeholder="Write content here"></textarea>
                </div>
                <div class="input-group mb-3">
                    <input type="submit" class="btn btn-sm btn-primary gsa-text-white" name="add" value="Add">
                </div>
            </form>
        </main>

      </div>
    </div>
</body>
</html>