<?php $page = "Blog Posts"; $action = "list"; ?>
<?php include "../../routes/post.php"; ?>
<?php include "../layout/header.php"; ?>
  <body>

    <?php include "../layout/navbar.php"; ?>

    <div class="container-fluid">
      <div class="row">
        <?php include "../layout/sidenav.php"; ?>
        
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2"><?php echo $page; ?></h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                <a class="btn btn-sm btn-primary wln-text-white" href="blog/add">
                    Add New <i class="fas fa-plus"></i>
                </a>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-sm">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Title</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; 
                        foreach ($posts as $post) { ?>
                        <tr>
                            <td><?php echo $i++; ?></td>
                            <td><?php echo $post->title; ?></td>
                            <td><?php echo date_format(date_create($post->created_at), "M d, Y"); ?></td>
                            <td>
                                <a href="../blog/<?php echo $post->url; ?>" target="_blank" class="btn btn-sm btn-success wln-text-white" data-toggle="tooltip" data-placement="top" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="blog/edit/<?php echo $post->id; ?>" class="btn btn-sm btn-info wln-text-white" data-toggle="tooltip" data-placement="top" title="Edit">
                                    <i class="fas fa-pen"></i>
                                </a>
                                <a onclick="deleteModal(<?php echo $post->id; ?>);" class="btn btn-sm btn-danger wln-text-white" data-toggle="tooltip" data-placement="top" title="Delete">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </main>
      
      </div>
    </div>
    <?php include '../layout/delete.php'; ?>
  </body>
</html>