<?php
    $action = "login";
    $page = "Login"; 

    include '../../routes/user.php';
    include '../layout/header.php'; ?>

<body class="wln-white-light">
    <div class="container">
        <div class="row mx-5 px-5 pt-5 mt-5 mb-3 pb-3">
            <div class="col-sm-12 col-md-6 offset-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title wln-text-purple">Login</h5>
                        <p class="card-text">
                            <form action="" method="POST" autocomplete="off">
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="username"><i class="fas fa-user"></i></span>
                                    </div>
                                    <input type="text" name="username" class="form-control" placeholder="Username" required>
                                </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="password"><i class="fas fa-lock"></i></span>
                                    </div>
                                    <input type="password" name="password" class="form-control" placeholder="Password" required>
                                </div>
                                <div class="input-group mb-3">
                                    <input type="submit" class="btn btn-md rounded-0 btn-block wln-purple wln-text-white" name="login" value="Login">
                                </div>
                            </form>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row no-gutters mb-5">
            <div class="col">
                <h4 class="text-center wln-text-black-lighter">
                    Only accessible to web admin
                </h4>
            </div>
        </div>
        <div class="row no-gutters">
            <div class="col">
                <p class="text-center wln-text-black-lighter">
                    &copy; 2018 - <?php echo date('Y', strtotime('today')); ?>. Wish List Nepal. 
                    <br/>All rights reserved.
                </p>
            </div>
        </div>
    </div>
<?php include '../layout/scripts.php'; ?>
</body>
</html>