<?php $page = "Package"; $action="edit"; ?>
<?php include "../../routes/package.php"; ?>
<?php include "../layout/header.php"; ?>
<body>

    <?php include "../layout/navbar.php"; ?>

    <div class="container-fluid">
      <div class="row">
        <?php include "../layout/sidenav.php"; ?>
        
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Edit <?php echo $page; ?></h1>
            </div>
            <form action="" method="POST" autocomplete="off" enctype="multipart/form-data">
                <div class="input-group mb-3">
                    <h4> Basic Info </h4>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="name">Name*</span>
                    </div>
                    <input type="text" name="name" value="<?php echo $package->name; ?>" class="form-control" placeholder="Write the package name here" aria-label="Name" aria-describedby="name" required>
                </div>
                <div class="input-group mb-3">
                    <select class="custom-select" name="category" id="category" required>
                        <option disabled>Select a category </option>
                        <?php foreach ($categories as $category) { ?>
                            <option 
                                <?php if ($selectedCategory->id == $category->id) { ?>
                                selected
                                <?php } ?>
                                value="<?php echo $category->id; ?>">
                                <?php echo $category->category; ?>
                            </option>
                        <?php } ?>
                    </select>
                    <div class="custom-file ml-3">
                        <input type="hidden" name="oldImage" value="<?php echo $package->thumbnail; ?>">                                
                        <input type="file" name="fileToUpload" class="custom-file-input" id="thumbnail" aria-describedby="thumbnail">
                        <label class="custom-file-label" for="thumbnail">Choose thumbnail</label>
                    </div>    
                </div>
                <div class="input-group mb-3 justify-content-center">
                    <div class="col-6" id="displayThumbnail"> 
                        <img src="../assets/images/<?php echo $image->filename;?>" class="img-fluid">
                    </div>
                </div>
                <div class="input-group mb-3">
                    <textarea name="description" class="form-control editor-main" placeholder="Write description here"><?php echo $package->description; ?></textarea>
                </div>
                <div class="input-group mb-3">
                    <h4> Mark as popular? </h4>
                    <div class="btn-group btn-group-toggle ml-5" data-toggle="buttons">
                        <label class="btn btn-secondary <?php if ($package->popular == 1) { ?>active<?php } ?>">
                            <input type="radio" name="popular" value="1" id="option1" <?php if ($package->popular == 1) { ?>checked<?php } ?>> Yes
                        </label>
                        <label class="btn btn-secondary <?php if ($package->popular == 0) { ?>active<?php } ?>">
                            <input type="radio" name="popular" value="0" id="option2" <?php if ($package->popular == 0) { ?>checked<?php } ?>> No
                        </label>
                    </div>
                </div>
                <hr/>
                <div class="input-group mb-3">
                    <h4> Logistic Details </h4>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="days">Days*</span>
                    </div>
                    <input type="number" name="days" value="<?php echo $package->days; ?>" class="form-control" required>
                    <div class="input-group-prepend ml-3">
                        <span class="input-group-text" id="nights">Nights*</span>
                    </div>
                    <input type="number" name="nights" value="<?php echo $package->nights; ?>" class="form-control" required>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="altitude">Altitude</span>
                    </div>
                    <input type="number" name="altitude" value="<?php echo $package->altitude; ?>" class="form-control">
                    <select class="custom-select ml-3" name="level" id="level">
                        <option disabled>Select a level </option>
                        <option value="Beginner" <?php if ($package->level == 'Beginner') { ?> selected <?php }?>> Beginner </option>
                        <option value="Moderate" <?php if ($package->level == 'Moderate') { ?> selected <?php }?>> Moderate </option>
                        <option value="Difficult" <?php if ($package->level == 'Difficult') { ?> selected <?php }?>> Difficult </option>
                        <option value="Expert" <?php if ($package->level == 'Expert') { ?> selected <?php }?>> Expert </option>
                    </select>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="group_size">Group Size</span>
                    </div>
                    <input type="number" name="group_size" value="<?php echo $package->group_size; ?>" class="form-control">
                    <div class="input-group-prepend ml-3">
                        <span class="input-group-text" id="season">Season</span>
                    </div>
                    <input type="text" name="season" value="<?php echo $package->season; ?>" class="form-control">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="accommodation">Accommodation</span>
                    </div>
                    <input type="text" name="accommodation" value="<?php echo $package->accommodation; ?>" class="form-control" placeholder="Accommodation details" required>
                    <div class="input-group-prepend ml-3">
                        <span class="input-group-text" id="location">Location</span>
                    </div>
                    <input type="text" name="location" value="<?php echo $package->location; ?>" class="form-control">
                </div>
                <hr/>
                <div class="input-group mb-3">
                    <h4> Price Details </h4>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="starting_price">Starting Price*</span>
                    </div>
                    <input type="text" name="starting_price" value="<?php echo $package->starting_price; ?>" class="form-control" required>
                </div> 
                <div class="input-group mb-1">
                    <h5> Pricing Details </h5>
                </div> 
                <div class="input-group mb-3">
                    <textarea name="price_details" class="form-control editor-sub"><?php echo $package->price_details; ?></textarea>
                </div>  
                <div class="input-group mb-1">
                    <h5> Includes </h5>
                </div>    
                <div class="input-group mb-3">
                    <textarea name="includes" class="form-control editor-sub"><?php echo $package->includes; ?></textarea>
                </div>  
                <div class="input-group mb-1">
                    <h5> Excludes </h5>
                </div>    
                <div class="input-group mb-3">
                    <textarea name="excludes" class="form-control editor-sub"><?php echo $package->excludes; ?></textarea>
                </div>
                <hr/>
                <div class="input-group mb-3">
                    <h4> Notes </h4>
                </div>      
                <div class="input-group mb-3">
                    <textarea name="notes" class="form-control editor-main"><?php echo $package->notes; ?></textarea>
                </div>
                <div class="input-group mb-3">
                    <input type="submit" class="btn btn-sm btn-primary gsa-text-white" name="edit" value="Edit">
                </div>
            </form>
        </main>

      </div>
    </div>
</body>
</html>