<?php $page = "Testimonial"; $action="edit"; ?>
<?php include "../../routes/testimonials.php"; ?>
<?php include "../layout/header.php"; ?>
<body>

    <?php include "../layout/navbar.php"; ?>

    <div class="container-fluid">
      <div class="row">
        <?php include "../layout/sidenav.php"; ?>
        
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Add New <?php echo $page; ?></h1>
            </div>
            <form action="" method="POST" autocomplete="off" enctype="multipart/form-data">
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="full_name">Full Name</span>
                    </div>
                    <input type="text" name="full_name" value="<?php echo $testimonial->full_name; ?>" class="form-control" placeholder="Write the full name here" required>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="position">Position</span>
                    </div>
                    <input type="text" name="position" value="<?php echo $testimonial->position; ?>" class="form-control" placeholder="Write the position here">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="company">Company</span>
                    </div>
                    <input type="text" name="company" value="<?php echo $testimonial->company; ?>" class="form-control" placeholder="Write the company name here" required>
                </div>
                <div class="input-group mb-3">
                    <div class="custom-file ml-3">
                        <input type="hidden" name="oldImage" value="<?php echo $testimonial->image; ?>">                                
                        <input type="file" name="fileToUpload" class="custom-file-input" id="thumbnail" aria-describedby="thumbnail">
                        <label class="custom-file-label" for="thumbnail">Choose thumbnail</label>
                    </div>    
                </div>
                <div class="input-group mb-3 justify-content-center">
                    <div class="col-6" id="displayThumbnail"> 
                        <img src="../assets/images/<?php echo $image->filename;?>" class="img-fluid">
                    </div>
                </div>
                <div class="input-group mb-3">
                    <textarea name="quote" class="form-control editor-main" placeholder="Write the quote here"><?php echo $testimonial->quote; ?></textarea>
                </div>
                <div class="input-group mb-3">
                    <input type="submit" class="btn btn-sm btn-primary gsa-text-white" name="edit" value="Edit">
                </div>
            </form>
        </main>

      </div>
    </div>
</body>
</html>