<?php
switch($_SERVER["REDIRECT_STATUS"]){
    case 400:
        $page = "400 Bad Request";
        $error_description = "The request can not be processed due to bad syntax";
    break;

    case 401:
        $page = "401 Unauthorized";
        $error_description = "The request has failed authentication";
    break;

    case 403:
        $page = "403 Forbidden";
        $error_description = "The server refuses to response to the request";
    break;

    case 404:
        $page = "404 Not Found";
        $error_description = "The requested resource could not be found.";
    break;

    case 500:
        $page = "500 Internal Server page";
        $error_description = "There was an page which doesn't fit any other page message";
    break;

    case 502:
        $page = "502 Bad Gateway";
        $error_description = "The server was acting as a proxy and received a bad request.";
    break;

    case 504:
        $page = "504 Gateway Timeout";
        $error_description = "The server was acting as a proxy and the request timed out.";
    break;
}

?>
<?php include "./layout/header.php"; ?>
<body>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <img src="assets/images/wishlistnepal.png" class="img-fluid">
            </div>
            <div class="col-lg-6 my-5 py-5">
                <h1> <?php echo $page; ?> </h1>
                <h4>
                    <?php echo $error_description; ?>
                </h4>
                Go back to <a href=""> home page</a>
            </div>
        </div>
    </div>
</body>
</html>