<div class="container-fluid py-5">
    <div class="row px-5">
        <div class="col-12">
        <h1 class="wln-text-purple"> <?php echo $package->name; ?> </h1>
        <hr style="width: 50%; border: solid 2px #d66325; "/>    
        </div>
    </div>
    <div class="row mb-5">
        <div class="col-12 px-0 mx-0">
                <?php 
                    $image_result = $image_service->get($package->thumbnail);
                    $image = new Image(
                        $image_result['id'],
                        $image_result['caption'],
                        $image_result['filename']
                    ); 
                ?>
            <img src="assets/images/<?php echo $image->filename; ?>" onerror="this.src='assets/<?php echo $onerror; ?>';" class="img-fluid" alt="<?php echo $image->caption; ?>">
        </div>
    </div>
    <div class="row my-5">
        <div class="col-sm-12 col-md-3">
            <div class="card border-0 rounded-0 wln-white-lighter shadow-sm">
                <div class="card-body">

                    <strong class="wln-text-purple"> Duration </strong>
                    <hr/>
                    <h6> <?php echo $package->days; ?> Days & <?php echo $package->nights; ?> Nights </h6>
                    <hr/>

                    <strong class="wln-text-purple"> Location </strong>
                    <hr/>
                    <h6> <?php echo $package->location; ?> </h6>
                    <hr/>

                    <?php if($package->altitude) { ?>
                    <strong class="wln-text-purple"> Altitude </strong>
                    <hr/>
                    <h6> <?php echo $package->altitude; ?>m </h6>
                    <hr/>
                    <?php } ?>

                    <?php if($package->level) { ?>
                    <strong class="wln-text-purple"> Level </strong>
                    <hr/>
                    <h6> <?php echo $package->level ?> </h6>
                    <hr/>
                    <?php } ?>
                    
                    <?php if($package->group_size) { ?>
                    <strong class="wln-text-purple"> Group Size </strong>
                    <hr/>
                    <h6> <?php echo $package->group_size; ?> people </h6>
                    <hr/>
                    <?php } ?>

                    <strong class="wln-text-purple"> Starting Price </strong>
                    <hr/>
                    <h6> <?php echo $package->starting_price; ?> per pax </h6>
                    <hr/>
                </div>
            </div>
        </div>
        <div class="col-sm-12 col-md-9">
            <ul class="nav nav-tabs rounded-0" id="myTab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active wln-text-purple p-3" id="overview-tab" data-toggle="tab" href="#overview" role="tab" aria-controls="overview" aria-selected="true">Overview</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link wln-text-purple p-3" id="itinerary-tab" data-toggle="tab" href="#itinerary" role="tab" aria-controls="itinerary" aria-selected="false">Itinerary</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link wln-text-purple p-3" id="accommodation-tab" data-toggle="tab" href="#accommodation" role="tab" aria-controls="accommodation" aria-selected="false">Accommodation</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link wln-text-purple p-3" id="cost-tab" data-toggle="tab" href="#cost" role="tab" aria-controls="cost" aria-selected="false">Cost</a>
                </li>
                <?php if ($package->notes) { ?>
                <li class="nav-item">
                    <a class="nav-link wln-text-purple p-3" id="notes-tab" data-toggle="tab" href="#notes" role="tab" aria-controls="notes" aria-selected="false">Notes</a>
                </li>
                <?php } ?>
            </ul>
            <div class="tab-content shadow-sm" id="myTabContent">
                <div class="tab-pane fade wln-white-lighter show active" id="overview" role="tabpanel" aria-labelledby="overview-tab">
                    <div class="card border-0 rounded-0 wln-white-lighter">
                        <div class="card-body px-5">
                            <p> <?php echo $package->description; ?></p>
                            <strong class="wln-text-purple"> Best Season </strong>
                            <hr class="w-50"/>
                            <p> <?php echo $package->season; ?> </p>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade wln-white-lighter" id="itinerary" role="tabpanel" aria-labelledby="itinerary-tab">
                    <div class="card border-0 rounded-0 wln-white-lighter">
                        <div class="card-body">
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-12 col-lg-12">
                                            <div id="itinerary">
                                                <div class="itinerary-list">
                                                    <?php foreach($itinerary as $itinerary_entry) { ?>
                                                        <div class="itinerary-item">
                                                            <div class="itinerary-icon status-intransit">
                                                                <i class="fas fa-circle wln-text-orange"></i>
                                                            </div>
                                                            <div class="itinerary-date"> 
                                                                <h5 class="wln-text-purple"><?php echo "Day " . $itinerary_entry->day; ?></h5>
                                                    <?php if ($itinerary_entry->hour) { ?> <span><?php echo $itinerary_entry->hour . " hours"; ?></span> <?php } ?>
                                                            </div>
                                                            <div class="itinerary-content">
                                                                <h5 class="wln-text-purple"> <?php echo $itinerary_entry->heading; ?></h5>
                                                                <hr/>
                                                                <p> <?php echo $itinerary_entry->details; ?></p>
                                                            </div>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade wln-white-lighter" id="accommodation" role="tabpanel" aria-labelledby="accommodation-tab">
                    <div class="card border-0 rounded-0 wln-white-lighter">
                        <div class="card-body px-5">
                            <p> <?php echo $package->accommodation; ?> </p>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="cost" role="tabpanel" aria-labelledby="cost-tab">
                    <div class="card border-0 rounded-0 wln-white-lighter">
                        <div class="card-body px-5">
                            <strong class="wln-text-purple"> Starting Price </strong>
                            <hr class="w-50"/>
                            <p> <?php echo $package->starting_price; ?> per pax </p>
                            
                        <?php if ($package->price_details) { ?>
                            <strong class="wln-text-purple"> Price Details </strong>
                            <hr class="w-50"/>
                            <p> <?php echo $package->price_details; ?> </p>
                            
                        <?php } ?>
                        <?php if ($package->includes) { ?>
                            <strong class="wln-text-purple"> Includes </strong>
                            <hr class="w-50"/>
                            <p> <?php echo $package->includes; ?> </p>
                        <?php } ?>
                        <?php if ($package->excludes) { ?>
                            <strong class="wln-text-purple"> Excludes </strong>
                            <hr class="w-50"/>
                            <p> <?php echo $package->excludes; ?> </p>
                        <?php } ?>
                        </div>
                    </div>
                </div>
                <?php if ($package->notes) { ?>
                <div class="tab-pane fade wln-white-lighter" id="notes" role="tabpanel" aria-labelledby="notes-tab">
                    <div class="card border-0 rounded-0 wln-white-lighter">
                        <div class="card-body px-5">
                            <p> <?php echo $package->notes; ?> </p>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <div class="row px-5">
        <div class="col-12">
            <hr/>
            <h3 class="wln-text-purple"> Other Packages </h3>
            <hr class="w-50" style="border: solid 2px #d66325;"/>
        </div>
        <?php foreach ($packages as $other_package) { ?>
            <div class="col-sm-12 col-md-4 mb-5">
                <div class="card border img-box shadow-sm">
                    <?php 
                        $image_result = $image_service->get($other_package->thumbnail);
                        $image = new Image(
                            $image_result['id'],
                            $image_result['caption'],
                            $image_result['filename']
                        ); 
                    ?>
                    <img src="assets/images/<?php echo $image->filename; ?>" onerror="this.src='assets/<?php echo $onerror; ?>';" class="card-img-top img-fluid package-img" alt="<?php echo $image->caption; ?>">
                    <div class="card-body">
                        <div class="container-fluid px-0">
                            <div class="row">
                                <div class="col-12">
                                    <a href="packages/<?php echo $package->url; ?>">
                                        <h5 class="card-title wln-text-purple"> <?php echo $other_package->name; ?></h5>
                                    </a>
                                    <p class="card-text">
                                        <i class="fas fa-map-marker-alt wln-text-orange mr-2"></i>
                                        <?php echo $other_package->location; ?>
                                        <i class="fas fa-calendar-alt wln-text-orange mr-2 ml-5"></i>
                                        <?php echo $other_package->days; ?>D/<?php echo $other_package->nights; ?>N
                                    </p>
                                    <p class="card-text"><?php echo $other_package->starting_price; ?> per pax</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>