<?php
    include "config.php";
    include "../admin/models/Package.php";
    include "../admin/models/Category.php";
    include "../admin/models/Image.php";

    include "../admin/services/PackageService.php";
    include "../admin/services/CategoryService.php";
    include "../admin/services/ImageService.php";

    $package_service = new PackageService($db);
    $category_service = new CategoryService($db);
    $image_service = new ImageService($db);

    /* Adventure Section */

    if (isset($_GET['category'])) {
        
        $category_result = $category_service->getCategoryWhere($_GET['category']);

        $category = new Category(
            $category_result['id'],
            $category_result['category']
        );

        $package_results = $package_service->listByCategory($category->id);

        $packages = array();
    
        foreach($package_results as $package_result) {
            $other_package = new Package(
                $package_result['id'],
                $package_result['name'],
                $package_result['url'],
                $package_result['thumbnail'],
                $package_result['description'],
                $package_result['category'],
                $package_result['popular'],
                $package_result['days'],
                $package_result['nights'],
                $package_result['location'],
                $package_result['starting_price'],
                $package_result['price_details'],
                $package_result['includes'],
                $package_result['excludes'],
                $package_result['altitude'],
                $package_result['level'],
                $package_result['group_size'],
                $package_result['accommodation'],
                $package_result['season'],
                $package_result['notes'],
                ""
            );
            array_push($packages, $other_package);
        }
    }


    /* Packages Section */

?>