<?php
    include "config.php";
    include "../admin/models/Event.php";
    include "../admin/models/Package.php";
    include "../admin/models/Image.php";
    include "../admin/models/Post.php";

    include "../admin/services/EventService.php";
    include "../admin/services/PackageService.php";
    include "../admin/services/ImageService.php";
    include "../admin/services/PostService.php";

    $event_service = new EventService($db);
    $package_service = new PackageService($db);
    $image_service = new ImageService($db);
    $post_service = new PostService($db);

    /* Event Section */

    if (isset($_GET['url'])) {

        $result = $event_service->getByEventURL($_GET['url']);
        
        $event = new Event(
            $result['id'],
            $result['title'],
            $result['event_url'],
            $result['date'],
            $result['time'],
            $result['fee'],
            $result['description'],
            $result['venue'],
            $result['thumbnail'],
            $result['url'],
            $result['url_text']
        );
        $event_results = $event_service->listByLimitToExcept($event->id, 3);
    } else {
        $event_results = $event_service->list();
    }

    $events = array();
    
    foreach($event_results as $event_result) {
        $other_event = new Event(
            $event_result['id'],
            $event_result['title'],
            $event_result['event_url'],
            $event_result['date'],
            $event_result['time'],
            $event_result['fee'],
            $event_result['description'],
            $event_result['venue'],
            $event_result['thumbnail'],
            $event_result['url'],
            $event_result['url_text']
        );
        array_push($events, $other_event);
    }

    $post_results = $post_service->listLimitTo(2);    

    $posts = array();

    foreach($post_results as $post_result) {
        $post = new Post(
            $post_result['id'],
            $post_result['title'],
            $post_result['url'],
            $post_result['thumbnail'],
            $post_result['author'],
            $post_result['content'],
            $post_result['created_at']
        );
        array_push($posts, $post);
    }

/* Blog Section */
    /* Packages Section */

    $package_results = $package_service->listPopularLimitTo(2);

    $packages = array();
    
    foreach($package_results as $package_result) {
        $package = new Package(
            $package_result['id'],
            $package_result['name'],
            $package_result['url'],
            $package_result['thumbnail'],
            $package_result['description'],
            $package_result['category'],
            $package_result['popular'],
            $package_result['days'],
            $package_result['nights'],
            $package_result['location'],
            $package_result['starting_price'],
            $package_result['price_details'],
            $package_result['includes'],
            $package_result['excludes'],
            $package_result['altitude'],
            $package_result['level'],
            $package_result['group_size'],
            $package_result['accommodation'],
            $package_result['season'],
            $package_result['notes'],
            ""
        );
        array_push($packages, $package);
    }

    /* Packages Section */

?>