<?php $page="Search Result"; ?>
<?php include "../routes/search.php"; ?>
<?php include "../layout/header.php"; ?>
<?php include "../layout/socialbar.php"; ?>
<?php include "../layout/navbar.php"; ?>
<body style="background-color: #f2f2f2;">
    <div class="container">
        <div class="row">
            <div class="col-sm-12 text-center my-5 pb-5">
                <form method="GET" action="search" autocomplete="off">
                    <div class="input-group input-group-lg">
                        <input type="text" id="q" name="q" value="<?php if (isset($_GET['q'])) { echo htmlspecialchars($_GET['q']); } ?>" class="form-control shadow" placeholder="Search locations, packages, activities" aria-describedby="search-btn">
                        <div class="input-group-append">
                            <button class="btn wln-purple" type="button" id="search-btn">
                                <i class="fas fa-search wln-text-orange"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <?php if (isset($_GET['q'])) { ?>
            <?php if ($packages) { ?>
                <div class="row">
                    <?php foreach ($packages as $package) { ?>
                        <?php 
                            $image_result = $image_service->get($package->thumbnail);
                            $image = new Image(
                                $image_result['id'],
                                $image_result['caption'],
                                $image_result['filename']
                            ); 
                        ?>
                        <div class="col-4 mb-5">
                            <img src="assets/images/<?php echo $image->filename; ?>" class="mr-3 img-fluid shadow-sm">
                        </div>
                        <div class="col-8 mb-5">
                            <div class="wln-white-light shadow-sm p-5">
                                <h4 class="mt-0 mb-1">
                                    <a class="wln-text-purple name" href="packages/<?php echo $package->url; ?>">
                                        <?php echo $package->name; ?>
                                    </a>
                                    <hr style="width: 50%; border: solid 2px #d66325; "/>
                                </h4>
                                <div class="mb-3"> <?php echo $package->days . " days/" . $package->nights . " nights"; ?> </div>
                                <div class="block-with-text mb-3">
                                    <?php echo $package->description; ?>
                                </div>
                                <h5> Starting at NRs. <?php echo $package->starting_price; ?></h5>
                            </div>
                        </div>            
                    <?php } ?>
                </div>
            <?php } ?>
            <?php if ($events) { ?>
                <div class="row">
                    <?php foreach ($events as $event) { ?>
                        <?php 
                            $image_result = $image_service->get($event->thumbnail);
                            $image = new Image(
                                $image_result['id'],
                                $image_result['caption'],
                                $image_result['filename']
                            ); 
                        ?>
                        <div class="col-4 mb-5">
                            <img src="assets/images/<?php echo $image->filename; ?>" class="mr-3 img-fluid shadow-sm">
                        </div>
                        <div class="col-8 mb-5">
                            <div class="wln-white-light shadow-sm p-5">
                                <h4 class="mt-0 mb-1">
                                    <a class="wln-text-purple name" href="events/<?php echo $event->event_url; ?>">
                                        <?php echo $event->title; ?>
                                    </a>
                                    <hr style="width: 50%; border: solid 2px #d66325; "/>
                                </h4>
                                <div class="mb-3"> 
                                    <i class="fas fa-calendar-alt mr-2 wln-text-orange"></i>
                                    <?php echo date_format(date_create($event->date), "M d, Y"); ?>

                                    <i class="fas fa-map-marker-alt ml-4 mr-2 wln-text-orange"></i>
                                    <?php echo $event->venue; ?>
                                </div>
                                <div class="block-with-text mb-3">
                                    <?php echo $event->description; ?>
                                </div>
                            </div>
                        </div>            
                    <?php } ?>
                </div>
            <?php } ?>
            <?php if ($posts) { ?>
                <div class="row">
                    <?php foreach ($posts as $post) { ?>
                        <?php 
                            $image_result = $image_service->get($post->thumbnail);
                            $image = new Image(
                                $image_result['id'],
                                $image_result['caption'],
                                $image_result['filename']
                            ); 
                        ?>
                        <div class="col-4 mb-5">
                            <img src="assets/images/<?php echo $image->filename; ?>" class="mr-3 img-fluid shadow-sm">
                        </div>
                        <div class="col-8 mb-5">
                            <div class="wln-white-light shadow-sm p-5">
                                <h4 class="mt-0 mb-1">
                                    <a class="wln-text-purple name" href="events/<?php echo $post->url; ?>">
                                        <?php echo $post->title; ?>
                                    </a>
                                    <hr style="width: 50%; border: solid 2px #d66325; "/>
                                </h4>
                                <div class="mb-3"> 
                                    <i class="fas fa-calendar-alt mr-2 wln-text-orange"></i>
                                    <?php echo date_format(date_create($post->created_at), "M d, Y"); ?>
                                </div>
                                <div class="block-with-text mb-3">
                                    <?php echo $post->content; ?>
                                </div>
                            </div>
                        </div>            
                    <?php } ?>
                </div>
            <?php } ?>
            <?php if (!$packages && !$events && !$posts) { ?>
                <div class="row">
                    <div class="col-sm-12 col-md-10 offset-md-1 text-center pb-5">
                        <h4> Sorry! We could not find what you were looking for. Try again with a simple query?</h4>
                    </div>
                </div>
            <?php } 
            } ?>
    </div>
</body>
<?php include "../layout/footer.php"; ?>
<?php include "../sections/scripts.php"; ?>
<script type="text/javascript">
$(document).ready(function() {
    const term = document.getElementById('q').value; // search query we want to highlight in results 
    
    Array.from(document.getElementsByClassName("name")).forEach(
        function(element, index, array) {
            changed = element.innerText.replace(new RegExp(term, "gi"), (match) => `<mark>${match}</mark>`);
            element.innerHTML = changed;
        }
    );

    Array.from(document.getElementsByClassName("block-with-text")).forEach(
        function(element, index, array) {
            changed = element.innerText.replace(new RegExp(term, "gi"), (match) => `<mark>${match}</mark>`);
            element.innerHTML = changed;
        }
    );
});
</script>