<h3 class="wln-text-purple"> Search </h3>
<hr class="w-50" style="border: solid 2px #d66325;" />
<form method="GET" action="search" autocomplete="off">
    <div class="input-group input-group">
        <input type="text" name="q" placeholder="Search here" class="form-control" aria-describedby="search-btn">
        <div class="input-group-append">
            <button class="btn wln-purple" type="button" id="search-btn">
                <i class="fas fa-search wln-text-orange"></i>
            </button>
        </div>
    </div>
</form>
<h3 class="wln-text-purple mt-5"> Popular Packages </h3>
<hr class="w-50" style="border: solid 2px #d66325;" />
<div class="row">
    <div class="col-12 pl-4">
        <?php foreach ($packages as $package) { ?>
        <div class="card border img-box mb-5 shadow-sm">
            <?php 
                            $image_result = $image_service->get($package->thumbnail);
                            $image = new Image(
                                $image_result['id'],
                                $image_result['caption'],
                                $image_result['filename']
                            ); 
                        ?>
            <img src="assets/images/<?php echo $image->filename; ?>"
                onerror="this.src='assets/<?php echo $onerror; ?>';" class="card-img-top img-fluid"
                alt="<?php echo $image->caption; ?>">
            <div class="card-body">
                <div class="container-fluid px-0">
                    <div class="row">
                        <div class="col-12">
                            <a href="packages/<?php echo $package->url; ?>">
                                <h5 class="card-title wln-text-purple"> <?php echo $package->name; ?></h5>
                            </a>
                            <p class="card-text">
                                <i class="fas fa-map-marker-alt wln-text-orange"></i>
                                <?php echo $package->location; ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
</div>
<?php if ($page != "Events") { ?>
    <h3 class="wln-text-purple mt-5"> Latest Events </h3>
    <hr class="w-50" style="border: solid 2px #d66325;" />
    <div class="row">
        <div class="col-12 pl-4">
            <?php foreach ($events as $event) { ?>
            <div class="card border img-box mb-5 shadow-sm">
                <?php 
                                $image_result = $image_service->get($event->thumbnail);
                                $image = new Image(
                                    $image_result['id'],
                                    $image_result['caption'],
                                    $image_result['filename']
                                ); 
                            ?>
                <img src="assets/images/<?php echo $image->filename; ?>"
                    onerror="this.src='assets/<?php echo $onerror; ?>';" class="card-img-top img-fluid"
                    alt="<?php echo $image->caption; ?>">
                <div class="card-body">
                    <div class="container-fluid px-0">
                        <div class="row">
                            <div class="col-12">
                                <a href="events/<?php echo $event->event_url; ?>">
                                    <h5 class="card-title wln-text-purple"> <?php echo $event->title; ?></h5>
                                </a>
                                <p class="card-text">
                                    <i class="fas fa-calendar-alt mr-2 wln-text-orange"></i>
                                    <?php echo date_format(date_create($event->date), "M d, Y"); ?>
                                    <i class="fas fa-map-marker-alt wln-text-orange ml-2"></i>
                                    <?php echo $event->venue; ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
<?php } ?>

<?php if ($page != "Blog") { ?>
    <h3 class="wln-text-purple mt-5"> Latest Blog </h3>
    <hr class="w-50" style="border: solid 2px #d66325;" />
    <div class="row">
        <div class="col-12 pl-4">
            <?php foreach ($posts as $post) { ?>
            <div class="card border img-box mb-5 shadow-sm">
                <?php 
                                $image_result = $image_service->get($post->thumbnail);
                                $image = new Image(
                                    $image_result['id'],
                                    $image_result['caption'],
                                    $image_result['filename']
                                ); 
                            ?>
                <img src="assets/images/<?php echo $image->filename; ?>"
                    onerror="this.src='assets/<?php echo $onerror; ?>';" class="card-img-top img-fluid"
                    alt="<?php echo $image->caption; ?>">
                <div class="card-body">
                    <div class="container-fluid px-0">
                        <div class="row">
                            <div class="col-12">
                                <a href="blog/<?php echo $post->url; ?>">
                                    <h5 class="card-title wln-text-purple"> <?php echo $post->title; ?></h5>
                                </a>
                                <p class="card-text">
                                    <i class="fas fa-calendar-alt mr-2 wln-text-orange"></i>
                                    <?php echo date_format(date_create($post->created_at), "M d, Y"); ?>    
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
<?php } ?>