<?php
    include "../../utils/Database.php";
    include "../../utils/functions.php";
    include "../../models/Event.php";
    include "../../models/Image.php";
    include "../../services/EventService.php";
    include "../../services/ImageService.php";
?>

<?php

    $database = new Database();
    $db = $database->connect();

    $image_service = new ImageService($db);
    $event_service = new EventService($db);

    if (isset($_POST['url'])) {
        $url = $_POST['url'];
    } else {
        $url = "";
    }

    if (isset($_POST['url_text'])) {
        $url_text = $_POST['url_text'];
    } else {
        $url_text = "";
    }

    if (isset($_POST['delete'])) {
        $action = 'delete';
    }

    switch($action) {
        case 'add':
            if(isset($_POST['add'])){

                $unique_post = $event_service->isUnique($_POST['title']);
                
                if ($unique_post) {
                    set_notification("An event with same title already exists","error");
                } else {
                    $new_image = new Image(0, $_POST['title'], $_FILES['fileToUpload']['name']);
                    $image_service->add($new_image);
                    
                    $result_list = $image_service->getLatest();
                    foreach($result_list as $result) {
                        $image = new Image(
                            $result['id'],
                            $result['caption'],
                            $result['filename']
                        );
                    }

                    $event = new Event(
                        0,
                        $_POST['title'],
                        getFormattedName($_POST['title']),
                        date("Y-m-d", (strtotime($_POST['date']))),
                        date("H:i:s", (strtotime($_POST['time']))),
                        $_POST['fee'],
                        $_POST['description'],
                        $_POST['venue'],
                        $image->id,
                        $url,
                        $url_text
                    );
                    
                    if (upload_file($_FILES, 'images')) {
                        $result = $event_service->add($event);
                        if($result){
                            set_notification("New event added", "success");
                        } else {
                            set_notification("Some error occurred", "error");
                        }
                    }
                }
                redirect("index");
            }
            break;
        case 'edit':
            if (isset($_POST['edit'])) {

                if ($_FILES['fileToUpload']['name'] == "") {
                    $get_image = $image_service->get($_POST['oldImage']);
                    $image = new Image(
                        $get_image['id'],
                        $get_image['caption'],
                        $get_image['filename']
                    );

                    $event = new Event(
                        $_GET['id'],
                        $_POST['title'],
                        getFormattedName($_POST['title']),
                        date("Y-m-d", (strtotime($_POST['date']))),
                        date("H:i:s", (strtotime($_POST['time']))),
                        $_POST['fee'],
                        $_POST['description'],
                        $_POST['venue'],
                        $image->id,
                        $url,
                        $url_text
                    );

                    $result = $event_service->update($event);

                    if($result){
                        set_notification("Event edited", "success");
                    } else {
                        set_notification("Some error occurred","error");
                    }
                } else {
                    $new_image = new Image(0, $_POST['title'], $_FILES['fileToUpload']['name']);
                    $image_service->add($new_image);
                    
                    $result_list = $image_service->getLatest();
                    foreach($result_list as $result) {
                        $image = new Image(
                            $result['id'],
                            $result['caption'],
                            $result['filename']
                        );
                    }

                    $event = new Event(
                        $_GET['id'],
                        $_POST['title'],
                        getFormattedName($_POST['title']),
                        date("Y-m-d", (strtotime($_POST['date']))),
                        date("H:i:s", (strtotime($_POST['time']))),
                        $_POST['fee'],
                        $_POST['description'],
                        $_POST['venue'],
                        $image->id,
                        $url,
                        $url_text
                    );

                    if (upload_file($_FILES, 'images')) {
                        $result = $event_service->update($event);
                        if($result){
                            set_notification("Event edited", "success");
                        } else {
                            set_notification("Some error occurred","error");
                        }
                    }
                }
            } else {

                $result = $event_service->get($_GET['id']);

                $event = new Event(
                    $result['id'],
                    $result['title'],
                    $result['event_url'],
                    $result['date'],
                    $result['time'],
                    $result['fee'],
                    $result['description'],
                    $result['venue'],
                    $result['thumbnail'],
                    $result['url'],
                    $result['url_text']
                );

                $object = $image_service->get($event->thumbnail);
                $image = new Image(
                    $object['id'],
                    $object['caption'],
                    $object['filename']
                );
            }
            break;
        case 'list':
            $result_list = $event_service->list();
            
            $events = array();
            
            foreach($result_list as $result) {
                $event = new Event(
                    $result['id'],
                    $result['title'],
                    $result['event_url'],
                    $result['date'],
                    $result['time'],
                    $result['fee'],
                    $result['description'],
                    $result['venue'],
                    $result['thumbnail'],
                    $result['url'],
                    $result['url_text']
                );
                array_push($events, $event);
            }

            break;
        case 'delete':
            $object = $event_service->get($_POST['deleteId']);
                    
            $event = new Event(
                $object['id'],
                $object['title'],
                $result['event_url'],
                $object['date'],
                $object['time'],
                $object['fee'],
                $object['description'],
                $object['venue'],
                $object['thumbnail'],
                $object['url'],
                $object['url_text']
            );
            if ($event) {
                $result = $event_service->delete($event);
                if($result){
                    set_notification("Event deleted", "success");
                } else {
                    set_notification("Some error occurred", "error");
                }
            }
            redirect("event");
            break;
        default:
            continue;
    }
?>