<?php
    include "../../utils/Database.php";
    include "../../utils/functions.php";
    include "../../models/Package.php";
    include "../../models/Image.php";
    include "../../models/Category.php";
    include "../../services/PackageService.php";
    include "../../services/ImageService.php";
    include "../../services/CategoryService.php";
?>

<?php

    $database = new Database();
    $db = $database->connect();
    $image_service = new ImageService($db);

    $package_service = new PackageService($db);
    $category_service = new CategoryService($db);

    if (isset($_POST['delete'])) {
        $action = 'delete';
    }

    switch($action) {
        case 'add':
            $category_list = $category_service->list();
            
            $categories = array();
            
            foreach($category_list as $result) {
                $category = new Category(
                        $result['id'],
                        $result['category']
                    );
                array_push($categories, $category);
            }

            if(isset($_POST['add'])){

                $unique_post = $package_service->isUnique($_POST['name']);
                
                if ($unique_post) {
                    set_notification("A package with same name already exists","error");
                } else {
                    $new_image = new Image(0, $_POST['name'], $_FILES['fileToUpload']['name']);
                    $image_service->add($new_image);
                    $result_list = $image_service->getLatest();

                    foreach($result_list as $result) {
                        $image = new Image(
                            $result['id'],
                            $result['caption'],
                            $result['filename']
                        );
                    }

                    $package = new Package(
                        0,
                        $_POST['name'],
                        getFormattedName($_POST['name']),
                        $image->id,
                        $_POST['description'],
                        $_POST['category'],
                        $_POST['popular'],
                        $_POST['days'],
                        $_POST['nights'],
                        $_POST['location'],
                        $_POST['starting_price'],
                        $_POST['price_details'],
                        $_POST['includes'],
                        $_POST['excludes'],
                        $_POST['altitude'],
                        $_POST['level'],
                        $_POST['group_size'],
                        $_POST['accommodation'],
                        $_POST['season'],
                        $_POST['notes'],
                        date('Y-m-d H:i:s')
                    );
                    
                    if (upload_file($_FILES, 'images')) {
                        $result = $package_service->add($package);

                        if($result){
                            set_notification("New package added", "success");
                        } else {
                            set_notification("Some error occurred", "error");
                        }
                    }
                }
                redirect("../package");
            }
            break;
        case 'edit':
            if (isset($_POST['edit'])) {

                if ($_FILES['fileToUpload']['name'] == "") {
                    $get_image = $image_service->get($_POST['oldImage']);
                    $image = new Image(
                        $get_image['id'],
                        $get_image['caption'],
                        $get_image['filename']
                    );

                    $package = new Package(
                        $_GET['id'],
                        $_POST['name'],
                        getFormattedName($_POST['name']),
                        $image->id,
                        $_POST['description'],
                        $_POST['category'],
                        $_POST['popular'],
                        $_POST['days'],
                        $_POST['nights'],
                        $_POST['location'],
                        $_POST['starting_price'],
                        $_POST['price_details'],
                        $_POST['includes'],
                        $_POST['excludes'],
                        $_POST['altitude'],
                        $_POST['level'],
                        $_POST['group_size'],
                        $_POST['accommodation'],
                        $_POST['season'],
                        $_POST['notes'],
                        ""
                    );

                    $result = $package_service->update($package);
                    if($result){
                        set_notification("Package edited", "success");
                    } else {
                        set_notification("Some error occurred", "error");
                    }
                } else {
                    $new_image = new Image(0, $_POST['name'], $_FILES['fileToUpload']['name']);
                    $image_service->add($new_image);
                    
                    $result_list = $image_service->getLatest();
                    foreach($result_list as $result) {
                        $image = new Image(
                            $result['id'],
                            $result['caption'],
                            $result['filename']
                        );
                    }

                    $package = new Package(
                        $_GET['id'],
                        $_POST['name'],
                        getFormattedName($_POST['name']),
                        $image->id,
                        $_POST['description'],
                        $_POST['category'],
                        $_POST['popular'],
                        $_POST['days'],
                        $_POST['nights'],
                        $_POST['location'],
                        $_POST['starting_price'],
                        $_POST['price_details'],
                        $_POST['includes'],
                        $_POST['excludes'],
                        $_POST['altitude'],
                        $_POST['level'],
                        $_POST['group_size'],
                        $_POST['accommodation'],
                        $_POST['season'],
                        $_POST['notes'],
                        ""
                    );
    
                    if (upload_file($_FILES, 'images')) {
                        $result = $package_service->update($package);
                        if($result){
                            set_notification("Package edited", "success");
                        } else {
                            set_notification("Some error occurred", "error");
                        }
                    }
                }
                $category_list = $category_service->list();
            
                $categories = array();
                
                foreach($category_list as $result) {
                    $category = new Category(
                        $result['id'],
                        $result['category']
                    );
                    array_push($categories, $category);
                }

                $object = $category_service->get($package->category);

                $selectedCategory = new Category(
                    $object['id'],
                    $object['category']
                );
            } else {
                $category_list = $category_service->list();
            
                $categories = array();
                
                foreach($category_list as $result) {
                    $category = new Category(
                        $result['id'],
                        $result['category']
                    );
                    array_push($categories, $category);
                }

                $result = $package_service->get($_GET['id']);

                $package = new Package(
                    $result['id'],
                    $result['name'],
                    $result['url'],
                    $result['thumbnail'],
                    $result['description'],
                    $result['category'],
                    $result['popular'],
                    $result['days'],
                    $result['nights'],
                    $result['location'],
                    $result['starting_price'],
                    $result['price_details'],
                    $result['includes'],
                    $result['excludes'],
                    $result['altitude'],
                    $result['level'],
                    $result['group_size'],
                    $result['accommodation'],
                    $result['season'],
                    $result['notes'],
                    ""
                );

                $object = $category_service->get($package->category);

                $selectedCategory = new Category(
                    $object['id'],
                    $object['category']
                );

                $object3 = $image_service->get($package->thumbnail);
                $image = new Image(
                    $object3['id'],
                    $object3['caption'],
                    $object3['filename']
                );
            }
            break;
        case 'list':
            $result_list = $package_service->list();
            
            $packages = array();

            foreach($result_list as $result) {
                $package = new Package(
                    $result['id'],
                    $result['name'],
                    $result['url'],
                    $result['thumbnail'],
                    $result['description'],
                    $result['category'],
                    $result['popular'],
                    $result['days'],
                    $result['nights'],
                    $result['location'],
                    $result['starting_price'],
                    $result['price_details'],
                    $result['includes'],
                    $result['excludes'],
                    $result['altitude'],
                    $result['level'],
                    $result['group_size'],
                    $result['accommodation'],
                    $result['season'],
                    $result['notes'],
                    $result['created_at']
                );
                array_push($packages, $package);
            }
            break;
        case 'delete':
            $object = $package_service->get($_POST['deleteId']);
                
            $package = new Package(
                $object['id'],
                $object['name'],
                $object['url'],
                $object['thumbnail'],
                $object['description'],
                $object['category'],
                $object['popular'],
                $object['days'],
                $object['nights'],
                $object['location'],
                $object['starting_price'],
                $object['price_details'],
                $object['includes'],
                $object['excludes'],
                $object['altitude'],
                $object['level'],
                $object['group_size'],
                $object['accommodation'],
                $object['season'],
                $object['notes'],
                ""
            );

            if ($package) {
                $result = $package_service->delete($package);
                if($result){
                    set_notification("Package deleted","success");
                } else {
                    set_notification("Some error occurred","error");
                }
            }
            redirect("package");
            break;
        default:
            continue;
    }
?>