<?php
    include "../../utils/Database.php";
    include "../../utils/functions.php";
    include "../../models/Testimonial.php";
    include "../../models/Image.php";
    include "../../services/TestimonialService.php";
    include "../../services/ImageService.php";
?>

<?php

    $database = new Database();
    $db = $database->connect();
    $image_service = new ImageService($db);

    $testimonial_service = new TestimonialService($db);

    if (isset($_POST['delete'])) {
        $action = 'delete';
    }

    switch($action) {
        case 'add':
            if(isset($_POST['add'])){

                $new_image = new Image(0, $_POST['full_name'], $_FILES['fileToUpload']['name']);
                $image_service->add($new_image);
                
                $result_list = $image_service->getLatest();
                foreach($result_list as $result) {
                    $image = new Image(
                        $result['id'],
                        $result['caption'],
                        $result['filename']
                    );
                }

                $testimonial = new Testimonial(
                    0,
                    $_POST['full_name'],
                    $_POST['position'],
                    $_POST['company'],
                    $image->id,
                    $_POST['quote']
                );
                
                if (upload_file($_FILES, 'images')) {
                    $result = $testimonial_service->add($testimonial);
                    if($result){
                        set_notification("New testimonial added","success");
                    } else {
                        set_notification("Some error occurred","error");
                    }
                }
                redirect("../testimonial");
            }
            break;
        case 'edit':
            if (isset($_POST['edit'])) {

                if ($_FILES['fileToUpload']['name'] == "") {
                    $get_image = $image_service->get($_POST['oldImage']);
                    $image = new Image(
                        $get_image['id'],
                        $get_image['caption'],
                        $get_image['filename']
                    );

                    $testimonial = new Testimonial(
                        $_GET['id'],
                        $_POST['full_name'],
                        $_POST['position'],
                        $_POST['company'],
                        $image->id,
                        $_POST['quote']
                    );

                    $result = $testimonial_service->update($testimonial);
                    if($result){
                        set_notification("Testimonial edited", "success");
                    } else {
                        set_notification("Some error occurred","error");
                    }
                } else {
                    $new_image = new Image(0, $_POST['full_name'], $_FILES['fileToUpload']['name']);
                    $image_service->add($new_image);
                    
                    $result_list = $image_service->getLatest();
                    
                    foreach($result_list as $result) {
                        $image = new Image(
                            $result['id'],
                            $result['caption'],
                            $result['filename']
                        );
                    }

                    $testimonial = new Testimonial(
                        $_GET['id'],
                        $_POST['full_name'],
                        $_POST['position'],
                        $_POST['company'],
                        $image->id,
                        $_POST['quote']
                    );


                    if (upload_file($_FILES, 'images')) {
                        $result = $testimonial_service->update($testimonial);
                        if($result){
                            set_notification("Testimonial edited","success");
                        } else {
                            set_notification("Some error occurred","error");
                        }
                    }
                }
                redirect("../testimonial");
            } else {

                $result = $testimonial_service->get($_GET['id']);

                $testimonial = new Testimonial(
                    $result['id'],
                    $result['full_name'],
                    $result['position'],
                    $result['company'],
                    $result['image'],
                    $result['quote']
                );

                $object = $image_service->get($testimonial->image);
                $image = new Image(
                    $object['id'],
                    $object['caption'],
                    $object['filename']
                );
            }
            break;
        case 'list':
            $result_list = $testimonial_service->list();
            
            $testimonials = array();
            
            foreach($result_list as $result) {
                $testimonial = new Testimonial(
                    $result['id'],
                    $result['full_name'],
                    $result['position'],
                    $result['company'],
                    $result['image'],
                    $result['quote']
                );
                array_push($testimonials, $testimonial);
            }

            break;
        case 'delete':
            $object = $testimonial_service->get($_POST['deleteId']);
                
            $testimonial = new Testimonial(
                $object['id'],
                $object['full_name'],
                $object['position'],
                $object['company'],
                $object['image'],
                $object['quote']
            );

            if ($testimonial) {
                $result = $testimonial_service->delete($testimonial);
                if($result){
                    set_notification("Testimonial deleted", "success");
                } else {
                    set_notification("Some error occurred","error");
                }
            }
            redirect("testimonial");
            break;
        default:
            continue;
    }
?>