<?php

class ConfigService {

    private $conn;
    private $table = "config";
    
    public function __construct($db) {
        $this->conn = $db;
    }

    public function update($config) {

        $query = "UPDATE " . $this->table . 
            " SET email = :email,
                    facebook = :facebook,
                    linkedin = :linkedin,
                    twitter = :twitter,
                    instagram = :instagram,
                    phone_number = :phone_number,
                    mobile_number = :mobile_number,
                    address = :address
                WHERE id = 1";
        
        $stmt = $this->conn->prepare($query);
        // print_r($config);
        $config->email = htmlspecialchars(strip_tags($config->email));
        $config->facebook = htmlspecialchars(strip_tags($config->facebook));
        $config->linkedin = htmlspecialchars(strip_tags($config->linkedin));
        $config->twitter = htmlspecialchars(strip_tags($config->twitter));
        $config->instagram = htmlspecialchars(strip_tags($config->instagram));
        $config->phone_number = htmlspecialchars(strip_tags($config->phone_number));
        $config->mobile_number = htmlspecialchars(strip_tags($config->mobile_number));
        
        $stmt->bindParam(':email', $config->email);
        $stmt->bindParam(':facebook', $config->facebook);
        $stmt->bindParam(':linkedin', $config->linkedin);
        $stmt->bindParam(':twitter', $config->twitter);
        $stmt->bindParam(':instagram', $config->instagram);
        $stmt->bindParam(':phone_number', $config->phone_number);
        $stmt->bindParam(':mobile_number', $config->mobile_number);
        $stmt->bindParam(':address', $config->address);
        
        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function get() {

        $query = "SELECT * FROM " . $this->table . " WHERE id = 1";

        $stmt = $this->conn->prepare($query);
        
        $stmt->execute();

        return ($stmt->fetch(PDO::FETCH_ASSOC));
    }
}

?>