<?php

class ImageService {

    private $conn;
    private $table = "image";
    
    public function __construct($db) {
        $this->conn = $db;
    }

    public function add($image) {

        $query = "INSERT INTO " . $this->table . 
            " SET caption = :caption,
                filename = :filename
            ";
        
        $stmt = $this->conn->prepare($query);
        
        $image->caption = htmlspecialchars(strip_tags($image->caption));
        $image->filename = htmlspecialchars(strip_tags($image->filename));
        
        $stmt->bindParam(':caption', $image->caption);
        $stmt->bindParam(':filename', $image->filename);
        
        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function update($image) {

        $query = "UPDATE " . $this->table . 
            " SET caption = :caption,
                filename = :filename
              WHERE id = :id";
        
        $stmt = $this->conn->prepare($query);
        
        $image->email = htmlspecialchars(strip_tags($image->caption));
        $image->filename = htmlspecialchars(strip_tags($image->filename));
        
        $stmt->bindParam(':image', $image->image);
        $stmt->bindParam(':filename', $image->filename);
        $stmt->bindParam(':id', $image->id);

        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function delete($image) {

        $query = "DELETE FROM " . $this->table . " WHERE id = :id";

        $stmt = $this->conn->prepare($query);
        
        $stmt->bindParam(':id', $image->id);
        
        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function list() {

        $query = "SELECT * FROM " . $this->table . " ORDER BY created_at DESC ";

        $stmt = $this->conn->prepare($query);
        $stmt->execute();

        $result_list = array();

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {       
            array_push($result_list, $row);
        }
        return $result_list;
    }

    public function get($id) {

        $query = "SELECT * FROM " . $this->table . " WHERE id = :id";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();

        return ($stmt->fetch(PDO::FETCH_ASSOC));
    }

    public function getLatest() {

        $query = "SELECT * FROM " . $this->table . " ORDER BY created_at DESC LIMIT 1";

        $stmt = $this->conn->prepare($query);
        $stmt->execute();

        $result_list = array();

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {       
            array_push($result_list, $row);
        }
        return $result_list;
    }

    public function isUnique($id) {

        $query = "SELECT COUNT(*) FROM " . $this->table . " WHERE id = :id";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $num_of_rows = $stmt->rowCount();

        if ($num_of_rows > 0) {
            return "false";
        } else {
            return "true";
        }
    }
}

?>