<?php

class TestimonialService {

    private $conn;
    private $table = "testimonial";
    
    public function __construct($db) {
        $this->conn = $db;
    }

    public function add($testimonial) {

        $query = "INSERT INTO " . $this->table . 
            " SET full_name = :full_name, 
                position = :position, 
                company = :company,
                image = :image, 
                quote = :quote";
        
        $stmt = $this->conn->prepare($query);
        
        $testimonial->full_name = htmlspecialchars(strip_tags($testimonial->full_name));
        $testimonial->email = htmlspecialchars(strip_tags($testimonial->position));
        $testimonial->company = htmlspecialchars(strip_tags($testimonial->company));
        $testimonial->image = htmlspecialchars(strip_tags($testimonial->image));
        $testimonial->quote = htmlspecialchars(strip_tags($testimonial->quote));

        $stmt->bindParam(':full_name', $testimonial->full_name);
        $stmt->bindParam(':position', $testimonial->position);
        $stmt->bindParam(':company', $testimonial->company);
        $stmt->bindParam(':image', $testimonial->image);
        $stmt->bindParam(':quote', $testimonial->quote);

        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function update($testimonial) {

        $query = "UPDATE " . $this->table . 
            " SET full_name = :full_name, 
                position = :position, 
                company = :company,
                image = :image,
                quote = :quote
              WHERE id = :id";
        
        $stmt = $this->conn->prepare($query);
        
        $testimonial->full_name = htmlspecialchars(strip_tags($testimonial->full_name));
        $testimonial->email = htmlspecialchars(strip_tags($testimonial->position));
        $testimonial->company = htmlspecialchars(strip_tags($testimonial->company));
        $testimonial->image = htmlspecialchars(strip_tags($testimonial->image));
        $testimonial->quote = htmlspecialchars(strip_tags($testimonial->quote));

        $stmt->bindParam(':full_name', $testimonial->full_name);
        $stmt->bindParam(':position', $testimonial->position);
        $stmt->bindParam(':company', $testimonial->company);
        $stmt->bindParam(':image', $testimonial->image);
        $stmt->bindParam(':quote', $testimonial->quote);
        $stmt->bindParam(':id', $testimonial->id);

        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function delete($testimonial) {

        $query = "DELETE FROM " . $this->table . " WHERE id = :id";

        $stmt = $this->conn->prepare($query);
        
        $stmt->bindParam(':id', $testimonial->id);
        
        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function list() {

        $query = "SELECT * FROM " . $this->table . " ORDER BY created_at DESC ";

        $stmt = $this->conn->prepare($query);
        $stmt->execute();

        $result_list = array();

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {       
            array_push($result_list, $row);
        }
        return $result_list;
    }

    public function listLimitTo($limit) {

        $query = "SELECT * FROM " . $this->table . " ORDER BY created_at DESC LIMIT " . $limit;

        $stmt = $this->conn->prepare($query);
        $stmt->execute();

        $result_list = array();

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {       
            array_push($result_list, $row);
        }
        return $result_list;
    }
    
    public function get($id) {

        $query = "SELECT * FROM " . $this->table . " WHERE id = :id";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();

        return ($stmt->fetch(PDO::FETCH_ASSOC));
    }
}

?>