<?php $page = "Gallery"; $action = "list"; ?>
<?php include "../../routes/gallery.php"; ?>
<?php include "../layout/header.php"; ?>
  <body>

    <?php include "../layout/navbar.php"; ?>

    <div class="container-fluid">
      <div class="row">
        <?php include "../layout/sidenav.php"; ?>
        
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2"><?php echo $page; ?></h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                <a class="btn btn-sm btn-primary gsa-text-white" href="gallery/add">
                    Add New <i class="fas fa-plus"></i>
                </a>
                </div>
            </div>
            <div class="container">
                <div class="row">
                    <?php foreach($gallery_images as $gallery_image) { ?>
                        <div class="col-md-3">
                            <?php 
                                $image_result = $image_service->get($gallery_image->image);
                                $image = new Image(
                                    $image_result['id'],
                                    $image_result['caption'],
                                    $image_result['filename']
                                ); 
                            ?>
                            <img src="../assets/images/<?php echo $image->filename; ?>" class="img-fluid my-3" style="height: 200px;">
                            
                            <a href="gallery/edit/<?php echo $gallery_image->id; ?>" class="btn btn-sm btn-info gsa-text-white" data-toggle="tooltip" data-placement="top" title="Edit">
                                <i class="fas fa-pen"></i>
                            </a>
                            <a onclick="deleteModal(<?php echo $gallery_image->id; ?>);" class="btn btn-sm btn-danger gsa-text-white" data-toggle="tooltip" data-placement="top" title="Delete">
                                <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </main>
      
    <?php include '../layout/delete.php'; ?>
      </div>
    </div>
  </body>
</html>