<?php $page = "Itinerary"; ?>
<?php include "../../routes/itinerary.php"; ?>
<?php include "../layout/header.php"; ?>
<body>

    <?php include "../layout/navbar.php"; ?>

    <?php if ($itineraryExists) { ?>
        <div class="container-fluid">
            <div class="row">
                <?php include "../layout/sidenav.php"; ?>
                
                <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                        <h1 class="h2">Edit <?php echo $page; ?></h1>
                    </div>
                    <form action="" method="POST" autocomplete="off" enctype="multipart/form-data">
                        <?php for ($day = 1; $day <= $package->days; $day++) { ?>
                            <input type="hidden" name="id[]" value="<?php echo $itinerary[$day]->id; ?>">
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="day">Day <?php echo $day; ?></span>
                                </div>
                                <input type="text" name="heading[]" value="<?php echo $itinerary[$day]->heading; ?>" class="form-control" placeholder="Write the heading here" required>
                            </div>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="hour">Hours </span>
                                </div>
                                <input type="text" name="hour[]" value="<?php echo $itinerary[$day]->hour; ?>" class="form-control" placeholder="Write the hour here (optional)">
                            </div>    
                            <div class="input-group mb-3">
                                <textarea name="detail[]" class="form-control editor-sub"><?php echo $itinerary[$day]->details; ?></textarea>
                            </div>
                        <?php } ?>
                        <div class="input-group mb-3">
                            <input type="submit" class="btn btn-sm btn-primary gsa-text-white" name="edit" value="Edit">
                        </div>
                    </form>
                </main>

            </div>
        </div>
    <?php } else { ?>
        <div class="container-fluid">
            <div class="row">
                <?php include "../layout/sidenav.php"; ?>
                
                <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                        <h1 class="h2">Add <?php echo $page; ?></h1>
                    </div>
                    <form action="" method="POST" autocomplete="off" enctype="multipart/form-data">
                        <?php for ($day = 1; $day <= $package->days; $day++) { ?>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="day">Day <?php echo $day; ?></span>
                                </div>
                                <input type="text" name="heading[]" class="form-control" placeholder="Write the heading here" required>
                            </div>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="hours">Hours</span>
                                </div>
                                <input type="number" name="hour[]" placeholder="Optional" class="form-control" value="0"/>
                            </div>    
                            <div class="input-group mb-3">
                                <textarea name="detail[]" class="form-control editor-sub"></textarea>
                            </div>
                        <?php } ?>
                        <div class="input-group mb-3">
                            <input type="submit" class="btn btn-sm btn-primary gsa-text-white" name="add" value="Add">
                        </div>
                    </form>
                </main>

            </div>
        </div>
    <?php } ?>

</body>
</html>