<div class="container-fluid wln-white p-md-5 pt-5">
    <?php 
        $image_result = $image_service->get($post->thumbnail);
        $image = new Image(
            $image_result['id'],
            $image_result['caption'],
            $image_result['filename']
        );
        
        $author_result = $author_service->get($post->author);
        $author = new Author(
            $author_result['id'],
            $author_result['full_name'],
            $author_result['email']
        );
    ?>
    <div class="row">
        
        <div class="col-sm-12 col-md-9">
            <img src="assets/images/<?php echo $image->filename; ?>" onerror="this.src='assets/<?php echo $onerror; ?>'" class="card-img-top img-fluid" alt="<?php echo $image->caption; ?>">
            <h2 class="wln-text-purple mt-5"> <?php echo $post->title; ?> </h2>
            <hr class="w-50" style="border: solid 2px #d66325;"/>
            <i class="far fa-user mr-1"></i>
            <?php echo $author->full_name; ?>
            <i class="far fa-calendar-alt ml-5 mr-1"></i>
            <?php echo date_format(date_create($post->created_at), "M d, Y"); ?>
            <hr/>
            <div class="p-3"><?php echo $post->content; ?></div>
            <hr/>
            <h3 class="wln-text-purple"> Other Posts </h3>
            <hr class="w-50" style="border: solid 2px #d66325;"/>
            <div class="row">
                <?php foreach ($blog_posts as $other_post) { ?>
                    <div class="col-sm-12 col-md-4">
                        <div class="card border-0 shadow-sm">
                            <?php 
                                $image_result = $image_service->get($other_post->thumbnail);
                                $image = new Image(
                                    $image_result['id'],
                                    $image_result['caption'],
                                    $image_result['filename']
                                ); 
                            ?>
                            <img src="assets/images/<?php echo $image->filename; ?>" class="card-img-top img-fluid" alt="<?php echo $image->caption; ?>">
                            <div class="card-body">
                                <p> 
                                    <i class="fas fa-calendar-alt mr-2"></i>
                                    <?php echo date_format(date_create($other_post->created_at), "M d, Y"); ?>
                                </p>
                                <a href="blog/<?php echo $other_post->url; ?>">
                                    <h4 class="card-title wln-text-purple"> <?php echo $other_post->title; ?></h4>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
        <div class="col-md-3 d-none d-md-block mt-5">
            <?php include '../sections/sidebar.php'; ?>
        </div>
    </div>
</div>