<div class="container-fluid my-5">
    <div class="row">
        <div class="col-md-9 col-sm-12 p-5">
            <div class="card wln-white-light shadow-lg">
                <?php 
                    $image_result = $image_service->get($event->thumbnail);
                    $image = new Image(
                        $image_result['id'],
                        $image_result['caption'],
                        $image_result['filename']
                    ); 
                ?>
                <img src="assets/images/<?php echo $image->filename; ?>" class="card-img-top img-fluid" alt="<?php echo $image->caption; ?>">
                <div class="card-body pl-4">
                    <div class="card" style="margin-top: -5%;">
                        <div class="card-body">
                            <h2 class="card-title wln-text-purple"><?php echo $event->title; ?></h2>
                            <hr class="w-50" style="border: solid 2px #d66325;"/>
                            <i class="fas fa-calendar-alt mr-2 wln-text-orange"></i>
                            <span class="mr-5 pr-5"><?php echo date_format(date_create($event->date), "M d, Y"); ?></span>
                            <i class="fas fa-map-marker-alt mr-2 ml-3 wln-text-orange"></i>
                            <span class="mr-5 pr-5"><?php echo $event->venue; ?></span>
                            <?php if (date_parse($event->date) < date_parse(date())) { ?>
                            <a href="events/<?php echo $event->event_url; ?>" class="btn btn-outline-purple wln-white-light wln-text-purple rounded-0 px-5 ml-5"> REGISTER </a>
                            <?php } ?>
                            <hr/>
                            <div>
                                <?php echo $event->description; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr/>
            <h3 class="wln-text-purple"> Other Events </h3>
            <hr class="w-50" style="border: solid 2px #d66325;"/>
            <div class="row">
                <?php foreach ($events as $other_events) { ?>
                    <div class="col-sm-12 col-md-4">
                        <div class="card border-0 shadow-sm">
                            <?php 
                                $image_result = $image_service->get($other_events->thumbnail);
                                $image = new Image(
                                    $image_result['id'],
                                    $image_result['caption'],
                                    $image_result['filename']
                                ); 
                            ?>
                            <img src="assets/images/<?php echo $image->filename; ?>" class="card-img-top img-fluid" alt="<?php echo $image->caption; ?>">
                            <div class="card-body">
                                <p> 
                                    <i class="fas fa-calendar-alt mr-2"></i>
                                    <?php echo date_format(date_create($other_events->date), "M d, Y"); ?>
                                </p>
                                <a href="events/<?php echo $other_events->event_url; ?>">
                                    <h4 class="card-title wln-text-purple"> <?php echo $other_events->title; ?></h4>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
        <div class="col-md-3 d-none d-md-block mt-5">
            <?php include "../sections/sidebar.php"; ?>
        </div>
    </div>
</div>