<?php 
    if (isset($_GET['url'])) {
        
        if ($page == "Packages") {
        
            $title = $package->name . " | Wish List Nepal";
            $description = substr($package->description, 0, 165);
            $url = "packages/" . $_GET['url'];
            $image_result = $image_service->get($package->thumbnail);
                        
        } elseif ($page == "Blog") {
        
            $title = $post->title. " | Wish List Nepal";
            $description = substr($post->content, 0, 165);
            $url = "blog/" . $_GET['url'];
            $image_result = $image_service->get($post->thumbnail);

        } elseif ($page == "Events") {
        
            $title = $event->title. " | Wish List Nepal";
            $description = substr($event->description, 0, 165);
            $url = "events/" . $_GET['url'];
            $image_result = $image_service->get($event->thumbnail);

        } elseif ($page == "Error") {
        
            $title = $event->title. " | Wish List Nepal";
            $description = "Wish List Nepal";
            $url = "error";
            $image_result = "";
        }
        
        $type="article";
    
    } else {
        if ($page == "Home") {

            $title = "Wish List Nepal | Your True Travel Genie";
            $url = "";
            $description = "Wish list Nepal is a travel company started by the young group of travel enthusiast to motivate other people in the country to travel with an aim to be a travel genie for all the people who want to wander and rejuvenate themselves through nature.";
            
        } elseif ($page == "Packages") {
            
            $title = $page . " | Wish List Nepal";
            $description = "Travel packages for Nepal, Himalayas and all over the world";
            $url = "packages/";

        } elseif ($page == "Blog") {
        
            $title = $page . " | Wish List Nepal";
            $description = "Travel Stories from Travellers in Nepal";
            $url = "blog/";

        } elseif ($page == "Events") {
            
            $title = $page . " | Wish List Nepal";
            $description = "Short one-day hikes and events organized by Wish List Nepal in and
                around Kathmandu Valley";
            $url = "events/";

        } elseif ($page == "About") {
        
            $title = $page . " | Wish List Nepal";
            $description = "Wish list Nepal is a travel company started by the young group of travel enthusiast to motivate other people in the country to travel with an aim to be a travel genie for all the people who want to wander and rejuvenate themselves through nature.";
            $url = "about/";

        } elseif ($page == "Message Confirmation") {

            $title = "Wish List Nepal | Your True Travel Genie";
            $url = "message-confirmation/";
            $description = "Your Message to Wish List Nepal has been confirmed";
        } elseif ($page == "Search Result") {

            $title = "Wish List Nepal | Your True Travel Genie";
            $url = "search/";
            $description = "Find Travel packages for Nepal, Himalayas and all over the world ";
        } else {
            $title = "Wish List Nepal | Your True Travel Genie";
            $url = "error/";
            $description = "Error page";
        }
        
        $type="website";
    }

    if (isset($image_result)){
        $image = new Image(
            $image_result['id'],
            $image_result['caption'],
            $image_result['filename']
        );
    } else {
        $image = new Image(
            0,
            'Wish List Nepal Logo',
            'wishlistnepal.png'
        );
    }
?>

    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />

    <title><?php echo $title; ?></title>

    <meta name=”description” content="<?php echo strip_tags($description); ?>">
    
    <meta property="og:type" content="<?php echo $type; ?>" /> 
    <meta property="og:title" content="<?php echo $title; ?>" />
    <meta property="og:description" content="<?php echo strip_tags($description); ?>" />
    <meta property="og:image" content="https://wishlistnepal.com/assets/images/<?php echo $image->filename; ?>" />
    <meta property="og:url" content="https://wishlistnepal.com/<?php echo $url; ?>" />
    <meta property="og:site_name" content="WISH LIST NEPAL" />

    <meta name="twitter:title" content="<?php echo $title; ?>">
    <meta name="twitter:description" content="<?php echo strip_tags($description); ?>">
    <meta name="twitter:image" content="https://wishlistnepal.com/assets/images/<?php echo $image->filename; ?>">

    <link rel="canonical" href="https://wishlistnepal.com/<?php echo $url; ?>"/>
