function setCookie(cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    var expires = "expires="+d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
    var name = cname + "=";
    var ca = document.cookie.split(';');
    for(var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) === ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) === 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "en";
}

$(function() {

    var t = {
        "Home": { np: "गृहपृष्ठ" },
        "Program": { np: "कार्यक्रम" },
        "Project": {np: "परियोजना"},
        "Blog": { np: "ब्लग" },
        "Event": {np: "कार्यक्रम"},
        "Startup": { np: "स्टार्टअप" },
        "Team": {np: "टोली"},
        "Our Story": {np: "हाम्रो कथा"},
        "0":{np: "०"},
        "1": { np: "१" }, "2": { np: "२" }, "3": { np: "३" }, "4": { np: "४" }, "5": { np: "५" }, "6": { np: "६" },
        "7": { np: "७" }, "8": { np: "८" }, "9": { np: "९" }, "10": { np: "१०" }, "11": { np: "११" }, "12": { np: "१२" },
        "13": { np: "१३" }, "14": { np: "१४" }, "15": { np: "१५" }, "16": { np: "१६" }, "17": { np: "१७" }, "18": { np: "१८" },
        "19": { np: "१९" }, "20": { np: "२०" }, "21": { np: "२१" }, "22": { np: "२२" }, "23": { np: "२३" }, "24": { np: "२४" },
        "25": { np: "२५" }, "26": { np: "२६" }, "27": { np: "२७" }, "28": { np: "२८" }, "29": { np: "२९" }, "30": { np: "३०" },
        "31": { np: "३१" }, "32": { np: "३२" }, "33": { np: "३३" }, "34": { np: "३४" }, "35": { np: "३५" }, "36": { np: "३६" },
        "37": { np: "३७" }, "38": { np: "३८" }, "39": { np: "३९" }, "40": { np: "४०" }, "41": { np: "४१" }, "42": { np: "४२" },
        "43": { np: "४३" }, "44": { np: "४४" }, "45": { np: "४५" }, "46": { np: "४६" }, "47": { np: "४७" }, "48": { np: "४८" },
        "49": { np: "४९" }, "50": { np: "५०" }, "51": { np: "५१" }, "52": { np: "५२" }, "53": { np: "५३" }, "54": { np: "५४" },
        "55": { np: "५५" }, "56": { np: "५६" }, "57": { np: "५७" }, "58": { np: "५८" }, "59": { np: "५९" }, "60": { np: "६०" },
        "2016": { np: "२०१६" }, "2017": { np: "२०१७" }, "2018": { np: "२०१८" }, "2019": { np: "२०१९" }, "2020": { np: "२०१०" },
        "2021": { np: "२०२१" }, "2022": { np: "२०२२" }, "2023": { np: "२०२३" }, "2024": { np: "२०२४" }, "2025": { np: "२०२५" },
        "2026": { np: "२०२६" }, "2027": { np: "२०२७" },
        question: {
            en: "What do you want to learn?",
            np: "तपाँई के पढ्न चहानुहुन्छ?"
        },
        "Class 1": { np: "कक्षा १" }, "Class 2": { np: "कक्षा २" }, "Class 3": { np: "कक्षा ३" },
        "Class 4": { np: "कक्षा ४" }, "Class 5": { np: "कक्षा ५" }, "Class 6": { np: "कक्षा ६" },
        "Class 7": { np: "कक्षा ७" }, "Class 8": { np: "कक्षा ८" }, "Class 9": { np: "कक्षा ९" },
        "Class 10": { np: "कक्षा १०" }, "Class 11": { np: "कक्षा ११" }, "Class 12": { np: "कक्षा १२" },
        "Classes": { np: "कक्षाहरू" },
        "About": { np: "हाम्रो बारेमा" },
        "Subjects": { np: "विषयहरू" },
        "SCIENCE": { np: "विज्ञान" },
        "MATHEMATICS": { np: "गणित" },
        "ENGLISH": { np: "अङ्‍ग्रेजी" },
        "NEPALI": { np: "नेपाली" },
        "SOCIAL STUDIES": { np: "सामाजिक अध्ययन" },
        "Featured Videos": { np: "विशेष भिडियोहरू"},
        enter: {
            en: "Select Language, type any topic and press enter",
            np: "भाषा छनोट गर्नुहोस्, कुनै विषय टाइप गर्नुहोस् र इनटर थिच्‍नुहोस् "
        },
        flipped_class_para_1: {
            en: "Flipped classes, by definition, “is a pedagogical model in which the typical lecture and homework elements of a course are reversed”. DLC, through this portal, aims at promoting flipped classes model across the country whereby students watch the lectures, in the form of short videos, in the home and utilize regular class hours for discussion.",
            np: "परिभाषा अनुसार फ्लिप्ड-गरिएको कक्षा, एक शैक्षणिक मोडेल हो जसमा पाठ्यक्रमका कुराहरू र गृहकार्यका तत्वहरू उल्टाइन्छन् । डि एल् सीले यस पोर्टलको माध्यमबाट देशमा फ्लिप्ड कक्षा मोडेलको प्रचार गर्ने लक्ष्य लिएको छ । विद्यार्थीहरुले फ्लिप्ड कक्षाहरू घरमा हेरेर स्कुल आउने गर्छन् भने प्रत्येक कक्षाको सुरुवात शिक्षकले अन्तरक्रियाबाट गर्ने गर्दछन् ।"
        },
        flipped_class_para_2: {
            en: "Researches across the world have shown that student’s learning has significantly improved when taught in this model as compared to the traditional face-to-face model. We aim at improving the learning of each and every student of Nepal.",
            np: "विश्वभरका अनुसन्धानहरूले के देखाएका छन् भने यस मोडेलमा अध्ययन गर्दा विद्यार्थीको शिक्षामा महत्त्वपूर्ण सुधार आएको पाइएको छ । हामी नेपालका प्रत्येक विद्यार्थीहरूको शिक्षा सुधार गर्ने उद्देश्य राख्दछौँ ।"
        },
        about_us_para_1: {
            en: "Our aim is to address the gap in the education system in Nepal. We focus on developing and delivering video lectures and tutorials for grade I to Grade XII students based on the curriculum developed by Curriculum Development Center, Ministry of Education of Government of Nepal.",
            np: "हाम्रो उद्देश्य नेपालको शिक्षा प्रणालीमा रहेको खाडललाई सम्बोधन गर्ने रहेको छ । हामी पाठ्यक्रम विकास केन्द्र, नेपाल सरकार, शिक्षा मन्त्रालयद्वारा विकसित पाठ्यक्रमको आधारमा कक्षा १ देखि कक्षा १२ सम्मको लागि भिडियो कक्षाहरूको विकास र वितरणमा ध्यान केन्द्रित गर्दछौँ ।"
        },
        about_us_para_2: {
            en: "We believe that this will help students, especially from public schools of Nepal who do not have access to teachers but have some kind of access to the internpt.",
            np: "हामी विश्वास गर्दछौँ कि यो शैक्षणिक मोडेलले नेपालका सरकारी विद्यालहरूमा अध्ययन गर्ने विद्यार्थीहरूलाई विशेष मद्दत गर्ने छ । शिक्षकहरूको पहुँचबाट टाढा रहेका तर इन्टरनेटको पहुँच सहज रूपमा हुने क्षेत्रका विद्यार्थीहरूले यो सेवाबाट विशेष लाभान्वित हुने छन् । "
        },
        "Deerwalk Learning Center": {
            np: "डियरवाक लर्निङ्ग सेन्टर"
        },
        "Digital Media Team": {
            np: "डडिजिटल मिडिया टोली"
        },
        "Flipped Class": {
            np: "फ्लिप्ड-गरिएको कक्षा"
        },
        "Instructors": {
            np: "प्रशिक्षकहरू"
        },
        "Contact": {
            np: "सम्पर्क"
        },
        "Terms of use": {
            np: "प्रयोगका शर्तहरू"
        },
        "All Rights Reserved.": {
            np: "| सर्वाधिकार सुरक्षित ।"
        },
        "Deerwalk Learning Center Terms of Service": {
            np: "प्रयोगका शर्तहरू"
        },
        "About Us": {
            np: "हाम्रो बारेमा"
        },
        "Units and Chapters": {
            np: "एकाइ र अध्यायहरू"
        },
        tos: {
          en: "<br>\n" +
          "                <h4> \n" +
          "                    Deerwalk Learning Center Terms of Service \n" +
          "                </h4>\n" +
          "                <h6> Last Updated: Dec 27, 2017 </h6>\n" +
          "                <br>\n" +
          "                <p>\n" +
          "                Thank you for using Deerwalk Learning Center. Please read these Terms and Conditions carefully\n" +
          "                    before accessing, using or obtaining any content or services provided by\n" +
          "                    <a href=\"http://dlc.dwit.edu.np\">http://dlc.dwit.edu.np</a>\n" +
          "                website operated by Deerwalk Learning Center. In these terms “<b>we</b>”, “<b>us</b>”, “<b>our</b>” or\n" +
          "                “<b>DLC</b>” refers to\n" +
          "                    Deerwalk Learning Centre and “you” refers to you as a user of this website.\n" +
          "                </p>\n" +
          "                <p>\n" +
          "                    Your access to and use of the service is conditionpd on your acceptance of and compliance with\n" +
          "                    these terms. These terms apply to all visitors, users and others who access or use the service.\n" +
          "                <p><b>\n" +
          "                    BY ACCESSING OR USING THE SERVICE YOU AGREE TO BE BOUND BY THESE TERMS. IF YOU DISAGREE WITH ANY\n" +
          "                    PART OF THE TERMS THEN YOU MAY NOT ACCESS THE SERVICE.\n" +
          "                </b></p>\n" +
          "                <br>\n" +
          "                <h5>Intellectual Property</h5>\n" +
          "                <p>\n" +
          "                    All copyright, trademarks, design rights, patents and other intellectual property rights\n" +
          "                    (registered and unregistered) in and on DLC belong to DLC. We reserve all of its rights.\n" +
          "                    Nothing in the terms grants you a right or license to use any trade mark, design right or\n" +
          "                    copyright ownpd or controlled by the DLC or any except as expressly provided in the terms.\n" +
          "                </p>\n" +
          "                <br>\n" +
          "                <h5>Access to Website Content</h5>\n" +
          "                <p>\n" +
          "                    We may permit user to share the content of the website (Videos and teaching materials) with a\n" +
          "                    selected group of user or download the content of the website for personal purpose. However,\n" +
          "                    alternation of the content is strictly restricted.\n" +
          "                </p>\n" +
          "                <br>\n" +
          "                <h5>User Content</h5>\n" +
          "                <p>\n" +
          "                    We may permit the posting of questions, comments, ratings, reviews etc. by you. You understand that\n" +
          "                    whether or not such user content is published, we do not guarantee any confidentiality with respect to\n" +
          "                    any submissions.\n" +
          "                </p>\n" +
          "                <br>\n" +
          "                <h5>Links to Other Websites</h5>\n" +
          "                <p>\n" +
          "                    Our Service may contain links to third-party websites or services that are not ownpd or controlled\n" +
          "                    by us.\n" +
          "                </p>\n" +
          "                <p>\n" +
          "                    We have no control over, and assumes no responsibility for, the content, privacy policies, or\n" +
          "                    practices of any third party web sites or services. You further acknowledge and agree we shall not\n" +
          "                    be responsible or liable, directly or indirectly, for any damage or loss caused or alleged to be\n" +
          "                    caused by or in connpction with use of or reliance on any such content, goods or services available\n" +
          "                    on or through any such websites or services.\n" +
          "                </p>\n" +
          "                <br>\n" +
          "                <h5>Changes</h5>\n" +
          "                <p>\n" +
          "                    We reserve the right, at our sole discretion, to modify or replace these terms at any time.\n" +
          "                    We can modify these terms at any time by posting a npwer version in our website. Please review\n" +
          "                    the terms of use regularly for changes.\n" +
          "                </p>\n" +
          "                <br>\n" +
          "                <h5>Contact Us</h5>\n" +
          "                <p>\n" +
          "                    If you have any questions about these terms, please contact us at learning@deerwalk.edu.np\n" +
          "                </p>",
          np: "<br>\n" +
          "                <h4> \n" +
          "                    डियरवाक लर्निङ्ग सेन्टरका सेवा सर्तहरू \n" +
          "                </h4>\n" +
          "                <h6> अन्तिम अपडेट: डिसेम्बर २७, २०१७  </h6>\n" +
          "                <br>\n" +
          "                <p>\n" +
          "                डियरवाक लर्निङ सेन्टरलार्इ प्रयाेग गर्नुभएकाेमा तपार्इँलार्इ धन्यवाद ! कृपया डियरवाक लर्निङ्ग सेन्टरद्वारा सञ्चालित \n" +
          "                    <a href=\"http://dlc.dwit.edu.np\">http://dlc.dwit.edu.np</a>\n" +
          "                वेव साइटबाट कुनै सामग्री वा सेवाहरूकाे उपभाेग, प्रयाेग र प्राप्त गर्नुपूर्व कृपया यी नियम र सर्तहरू ध्यानपूर्वक पढ्नुहाेस् । यहाँ उल्लिखित “<b>हामी</b>”, “<b>हामीलार्इ</b>”, “<b>हाम्राे</b>” वा\n" +
          "                “<b>डि एल सी</b>” ले डियरवाक लर्निङ सेन्टरलार्इ अवगत गराउदँछ भने “<b>तपार्इँ</b>” ले याे वेव साइट प्रयाेगकर्ताकाे रूपमा स्वम् तपार्इँलार्इ नै अवगत गराउँदछ । तपार्इँकाे उपभाेग र याे सेवाकाे प्रयाेग तपार्इँले हाम्रा यी सेवा र सर्तहरूलार्इ स्वीकार र पालना गर्ने सर्तमा निर्भर रहन्छ ।\n" +
          "                </p>\n" +
          "                <p>\n" +
          "                    यी सेवा र सर्तहरू ती सबै वेव साइट अागन्तुकहरू, प्रयाेगकर्ताहरू र अरू सबै जनालार्इ लागु हुन्छ, जाे हाम्राे सेवाकाे उपभाेग वा प्रयाेग गर्नुहुन्छ ।\n" +
          "                <p><b>\n" +
          "                    यी सेवा र सर्तहरू उपभाेग र प्रयाेग गर्न स्वीकृति जनाएर तपार्इँ  यी सर्तहरूसँग अाबद्ध  हुनु भएकाे छ ।  यदि तपार्इँ  यी सेवा र सर्तहरूका कुनै भागसँग सहमत हुनुहुन्न भने तपार्इँ  यी सेवाहरूकाे उपभाेग गर्न सक्नुहुने छैन । \n" +
          "                </b></p>\n" +
          "                <br>\n" +
          "                <h5>बाैद्धिक सम्पति</h5>\n" +
          "                <p>\n" +
          "                    डि एल सीमा भएमा सबै प्रतिलिपि अधिकार, ट्रेडमार्क, डिजाइन अधिकार, प्याटेन अधिकार तथा अन्य बाैद्धिक सम्पत्ति सम्बन्धी अधिकारहरू (दर्ता गरिएका वा नगरिएका) यस संस्थासँग सम्बन्धित छन् । हामी यसका सबै अधिकारहरू सुनिश्चित राख्दछाैँ । डि एल सीकाे स्वामित्व र नियन्त्रणमा रहेकाे उल्लिखित कुनै पनि सेवा र सर्तहरूले तपार्इँलार्इ यी ट्रेडमार्कहरूकाे प्रयाेग, इजाजत पत्र, डिजाइन अधिकार र प्रतिलिपि अधिकारकाे अनुमति दिएकाे छैन र यदि दिएमा सेवा र सर्त लागु हुने छ ।" +
          "                </p>\n" +
          "                <br>\n" +
          "                <h5>वेव साइट सामग्रीकाे पहुँच</h5>\n" +
          "                <p>\n" +
          "                    हामीले चयन गरेका निश्चित वेव साइट प्रयाेगकर्ता समूहलार्इ वेव साइटका (श्रव्य र दृश्य शैक्षिक सामग्री) सामग्रीहरू साझेदारी गर्न र वेव साइटका सामग्रीहरू व्यक्तिगत प्रयाेजनका लागि डाउनलाेड गर्न अनुमति प्रदान गरेका छाैँ, यद्यपि सामग्रीहरूमा कुनै पनि प्रकारकाे हेरफेर गर्न सख्त मनाही गरिएकाे छ ।\n" +
          "                </p>\n" +
          "                <br>\n" +
          "                <h5>सामग्री प्रयाेगकर्ताहरू</h5>\n" +
          "                <p>\n" +
          "                    हामीले तपार्इँका प्रश्नहरू, टिप्पणीहरू, मूल्याङ्कनहरू, समीक्षाहरू अादिलार्इ पाेष्ट गर्न अनुमति दिएका छाैँ । तपार्इँहरूका सामग्री प्रकाशित भए नभएकाे खण्डमा हामी त्यस्ता सामग्रीकाे गाेपनीयताकाे जिम्मेवारी नलिने कुरा जानकारी गराउँदछाैँ ।" +
          "                </p>\n" +
          "                <br>\n" +
          "                <h5>अरू वेव साइटसँगकाे सम्बन्ध</h5>\n" +
          "                <p>\n" +
          "                    हाम्राे सेवामा तेस्राे पक्षका वेव साइटहरू वा सेवाहरू हुन सक्छन्, जुन हाम्राे स्वामित्व वा नियन्त्रणमा रहँदैनन् ।\n" +
          "                </p>\n" +
          "                <p>\n" +
          "                    हाम्राे नियन्त्रणमा नभएका त्यस्ता तेस्राे पक्षका वेव साइट तथा सेवाहरू र यस सम्बन्धित सामग्रीहरू, गाेपनीयताका नीतिहरूप्रति हामी जिम्मेवारी बहन गर्दैनाैँ । यस्ता वेव साइट तथा सेवाहरूप्रति हामी प्रत्यक्ष र अप्रत्यक्ष कुनै पनि रूपमा सराेकार नराख्ने, यस्ता सामग्रीहरूकाे जिम्मेवारी नलिने र यस्ता सामग्रीहरूबाट हुने हानि नाेक्सानीकाे पनि जिम्मेवारी नलिने कुरा सहर्ष जानकारी गराउँछाैँ ।\n" +
          "                </p>\n" +
          "                <br>\n" +
          "                <h5>परिवर्तनहरू</h5>\n" +
          "                <p>\n" +
          "                    हामी कुनै पनि समयमा हाम्राे स्वविवेकले यी सेवा सर्तहरू परिमार्जन तथा प्रतिस्थापन गर्न सक्छाैँ । हामी यी सेवा र सर्तहरू कुनै पनि समयमा नयाँ संस्करण वेव साइटमा राखी परिमार्जन गर्न सक्दछाैँ । कृपया परिवर्तनका लागि नियमित रूपमा सेवा र सर्तहरूकाे समीक्षा गर्नुहाेस् ।" +
          "                </p>\n" +
          "                <br>\n" +
          "                <h5>सम्पर्कका लागि</h5>\n" +
          "                <p>\n" +
          "                    यदि तपार्इँहरूसँग यी सर्तहरूबारे कुनै प्रश्न तथा जिज्ञासा भए हामीलार्इ  learning@deerwalk.edu.np मा सम्पर्क गर्नुहाेला ।\n" +
          "                </p>"
        },
        about_us_para: {
            en: "<p>\n" +
            "                Deerwalk Learning Center, DLC, is a not-for-profit education organization established in 2016 under the Deerwalk Education Group.\n" +
            "            </p>\n" +
            "            <p>\n" +
            "                DLC was founded with the aim of addressing the gap in the education system in Nepal. It is focused on developing and delivering video lectures and tutorials for grade I to Grade XII students based on the curriculum developed by Curriculum Development Center, Ministry of Education of Government of Nepal. DLC believes that this will help students, especially from public schools of Nepal who do not have access to teachers but have some kind of access to the internpt.\n" +
            "            </p>\n" +
            "            <p>\n" +
            "                Deerwalk Education Group currently runs Deerwalk Institute of Technology, a college that runs four years bachelor's course in computer science, an affiliate college of Tribhuvan University and a Grade I to Grade XII high school with the name Deerwalk Sifal School.\n" +
            "            </p>",
            np: "<p>\n" +
            "                डियरवाक लर्निङ्ग सेन्टर, डि एल् सी, डियरवाक शैक्षिक गुप्रद्वारा सन् २०१६ मा स्थापित एक गैर-नाफामूलक संस्था हो । " +
            "            </p>\n" +
            "            <p>\n" +
            "                डि एल् सी स्थापना गर्नुको उद्देश्य नेपालको शिक्षा प्रणालीमा रहेको खाडललाई सम्बोधन गर्ने रहेको छ । हामी पाठ्यक्रम विकास केन्द्र, नेपाल सरकार, शिक्षा मन्त्रालयद्वारा विकसित पाठ्यक्रमको आधारमा कक्षा १ देखि कक्षा १२ सम्मको लागि भिडियो कक्षाहरूको विकास र वितरणमा ध्यान केन्द्रित गर्दछौँ । हामी विश्वास गर्दछौँ कि यो शैक्षणिक मोडेलले नेपालका सरकारी विद्यालहरूमा अध्ययन गर्ने विद्यार्थीहरूलाई विशेष मद्दत गर्ने छ । शिक्षकहरूको पहुँचबाट टाढा रहेका तर इन्टरनेटको पहुँच सहज रूपमा हुने क्षेत्रका विद्यार्थीहरू यो सेवाबाट विशेष लाभान्वित हुने छन् । \n" +
            "            </p>\n" +
            "            <p>\n" +
            "                डियरवाक शिक्षा समूहले हाल डियरवाक इन्स्टिट्युट अफ टेक्नोलोजी चलाउँछ जुन त्रिभुवन विश्वविद्यालयबाट सम्बन्धन प्राप्त कम्प्युटर विज्ञानमा चार वर्षे स्नातक विषय पढाउने संस्था हो । डियरवाक शिक्षा समूहले कक्षा १ देखि कक्षा १२ सम्म डियरवाक सिफल स्कुल पनि सञ्चालन गरिरहेको छ ।" +
            "            </p>"
        },
        insta_para: {
            en: "We have many professional instructors who have spent several years teaching their specific subjects. Our instructors are handpicked from a variety of teachers working in Deerwalk Sifal School. They are responsible for designing and teaching the flipped class.",
            np: "हामीसँग धेरै व्यवसायिक प्रशिक्षकहरू छन् जसले धैरै वर्ष अध्ययन अध्यापन गरेका छन् । हाम्रा धैरै जसो प्रशिक्षकहरूले डियरवाक सिफल स्कुलमा अध्यापन पनि गराउँछन् । फ्लिप्ड क्लासको निर्माण र शिक्षणका लागि उनीहरू जिम्मेवार रहेका छन् ।"
        },
        search: {
            en: "Search Here",
            np: "यहाँ खोज्नुहोस्"
        },
        "  Units": {
            np: "एकाइ"
        },
        "Join the discussion": {
            np: "छलफलमा सामेल हुनुहोस्"
        },
        "Post a comment": {
            np: "एउटा टिप्पणी पोस्ट गर्नुहोस्"
        },
        "Write a reply": {
            np: "जवाफ लेख्नुहोस्"
        },
        "Add a comment": {
            np: "एउटा टिप्पणी थप्नुहोस्"
        },
        "Add Comment": {
            np: "टिप्पणी थप्नुहोस्"
        },
        "Name": {
            np: "नाम"
        },
        "Email": {
            np: "इमेल"
        },
        "Comment": {
            np: "टिप्पणी"
        },
        "Join Class": {
            np: "कक्षामा सामेल हुनुहोस्"
        },
        "Alumni": {
            np: "पूर्व प्रशिक्षकहरू"
        },
        "classNotFound":{
            en: "Sorry! Class Not Available.",
            np: "माफ गर्नुहोस् । तपाईले खोज्नुभएको कक्षा उपलब्ध छैन ।"
        },
        "classNotAvailable":{
            en: "No Any Class Available",
            np: "कक्षा उपलब्ध छैन"
        },
        "fullName":{
            en: "Full Name: ",
            np: "पुरा नाम: "
        },
        "email":{
            en: "Email: ",
            np: "ईमेल: "
        },
        "contact":{
            en: "Contact: ",
            np: "सम्पर्क: "
        },
        "status":{
            en: "Status: ",
            np: "स्थिति: "
        },
        "currentInstructor":{
            en: "Current Instructor",
            np: "वर्तमान प्रशिक्षक"
        },
        "exInstructor":{
            en: "Alumni Instructor",
            np: "पूर्व प्रशिक्षक"
        },
        "introduction":{
            en: "Introduction:",
            np: "परिचय:"
        },
        "allClasses":{
            en: "All Classes",
            np: "सबै कक्षाहरु"
        },
        "sn":{
            en: "S.N.",
            np: "क्र.स."
        },
        "grade":{
            en: "Grade",
            np: "कक्षा"
        },
        "subject":{
            en: "Subject",
            np: "बिषय"
        },
        "unitNumber":{
            en: "Unit Number",
            np: "एकाइ न."
        },
        "unitName":{
            en: "Unit Name",
            np: "एकाइ नाम"
        },
        "chapterTitle":{
            en: "Chapter Title",
            np: "अध्यय शिर्षक"
        },
        "view":{
            en: "View",
            np: "हेर्नुहोस्"
        },
        "Address":{
            en: "Address",
            np: "ठेगाना"
        },
        "sifal":{
            en: "Sifal, Kathmandu Nepal",
            np: "सिफल, काठमाण्डै नेपाल"
        },
        "Facebook":{
            en: "Facebook",
            np: "फेसबुक"
        },
        "Phonp":{
            en: "Phonp",
            np: "फोन"
        },
        "Partnpr Schools":{
            np: "सम्बद्द विद्यालयहरु"
        },
        "totalClasses":{
            en: "Total Number of Classes: ",
            np: "जम्मा कक्षाहरुको सङ्‌ख्या: ‌"
        },
        "partnprSchoolDescription":{
            en:"The main aim of the DLC is to address the gap in the education system of Nepal. The video lectures and tutorials we create has been successful in helping the students of Nepal, especially the onps from the public sector. In order to provide our continued support, we are building a nptwork by partnpring with different schools of Nepal. \n These partnpr schools are mostly public schools that lack suitable and good teaching/learning environment. Our ultimate motive is to partnpr with schools of both public and private sectors and establish a nptwork between them.",
            np:"डियरवाक लर्निङ्ग सेन्टरको मुख्य उदेश्य भनेको नेपालको शैक्षिक प्रणालीमा रहेको दुरीलाई घटाउने हो । हामीले बनाएका भिडियो कक्षा र ट्युटोरियलहरु नेपाली विद्यार्थीलाई सहयोग पुर्याउन सफल भएको छ, विशेष गरी ग्रामीण भेगमा भएकाहरुलाई महत्वपुर्ण भुमिका निर्वाह गरेको छ । निरन्तर सहयोग प्रधान गर्ने उदेश्यले हामी नेपालका विभिन्न विद्यालय सम्बद्द सञ्जाल बनाउँदै छौ । \n\n सम्बद्द हुने विद्यालयहरुमा धेरै विद्यालयहरु सार्वजनिक विद्यालयहरु छन् जसमा राम्रो र उययुक्त पढ्ने/पढाउने वतावरणको कमी छ । हाम्रो अन्तिम उदेश्य भनेकै दुवै निजी तथा सार्वजनिक विद्यालयहरुसँग सम्बद्द भई उनीहरु बिच सञ्जाल बनाउने हो । "
        }
      
    };
    
    var loadThisLanguage = getCookie("lang_client");

    if(loadThisLanguage) {
        var _t = $('body').translate({lang: loadThisLanguage, t: t});
    } else {
        var _t = $('body').translate({lang: "en", t: t});
    }

    $(".lang_selector").click(function(ev) {
        // location.reload();
        var lang = $(this).attr("data-value");
        _t.lang(lang);

        setCookie("lang_client", lang, 1);
        // var isEnglish = true;
        // if (getCookie("lang_client") === "np") {
        //     nepaliContentSize();
        //     isEnglish = false;
        // } else {
        //     englishContentSize();
        //     isEnglish = true;
        // }
        // if(isEnglish){
        //     $('.englishTag').show();
        //     $('.nppaliTag').hide();
        // }else{
        //     $('.englishTag').hide();
        //     $('.nppaliTag').show();
        // }
    });
});

// function nppaliContentSize() {
//    /* $('p.trn').css("font-size","19px");
//     $('li.trn').css("font-size","19px");
//     $('span.trn').css("font-size","19px");
//     $('.nppaliTag').css("font-size","19px");*/
// }

// function englishContentSize() {
//     /*$('p.trn').css("font-size","17px");
//     $('li.trn').css("font-size","17px");
//     $('span.trn').css("font-size","17px");
//     $('.englishTag').css("font-size","17px");*/
// }