<?php
    include "config.php";
    include "../admin/models/Category.php";
    include "../admin/models/Post.php";
    include "../admin/models/Package.php";
    include "../admin/models/Image.php";
    include "../admin/models/Event.php";
    include "../admin/models/Slider.php";
    include "../admin/models/About.php";
    include "../admin/models/Testimonial.php";

    include "../admin/services/CategoryService.php";
    include "../admin/services/PostService.php";
    include "../admin/services/PackageService.php";
    include "../admin/services/ImageService.php";;
    include "../admin/services/EventService.php";
    include "../admin/services/SliderService.php";
    include "../admin/services/AboutService.php";
    include "../admin/services/TestimonialService.php";

    $database = new Database();
    $db = $database->connect();

    $image_service = new ImageService($db);
    $category_service = new CategoryService($db);
    $post_service = new PostService($db);
    $package_service = new PackageService($db);
    $event_service = new EventService($db);
    $slider_service = new SliderService($db);
    $about_service = new AboutService($db);
    $testimonial_service = new TestimonialService($db);

    $result_list = $slider_service->list();
            
    $sliders = array();
    
    foreach($result_list as $result) {
        $slider = new Slider(
            $result['id'],
            $result['title'],
            $result['subheading'],
            $result['image']
        );
        array_push($sliders, $slider);
    }

    /* About Section */

    $about_result = $about_service->get();

    $about = new About(
        $about_result["id"],
        $about_result["image"],
        $about_result["description"],
        $about_result["content"]
    );

    $object = $image_service->get($about->image);
    
    $about_image = new Image(
        $object["id"],
        $object["caption"],
        $object["filename"]
    );

    /* About Section */

    /* Blog Section */

    $post_results = $post_service->listLimitTo(6);

    $posts = array();
    
    foreach($post_results as $post_result) {
        $post = new Post(
            $post_result['id'],
            $post_result['title'],
            $post_result['url'],
            $post_result['thumbnail'],
            $post_result['author'],
            $post_result['content'],
            $post_result['created_at']
        );
        array_push($posts, $post);
    }

    /* Blog Section */

    /* Packages Section */

    $package_results = $package_service->list();

    $packages = array();
    
    foreach($package_results as $package_result) {
        $package = new Package(
            $package_result['id'],
            $package_result['name'],
            $package_result['url'],
            $package_result['thumbnail'],
            $package_result['description'],
            $package_result['category'],
            $package_result['popular'],
            $package_result['days'],
            $package_result['nights'],
            $package_result['location'],
            $package_result['starting_price'],
            $package_result['price_details'],
            $package_result['includes'],
            $package_result['excludes'],
            $package_result['altitude'],
            $package_result['level'],
            $package_result['group_size'],
            $package_result['accommodation'],
            $package_result['season'],
            $package_result['notes'],
            ""
        );
        array_push($packages, $package);
    }

    $popular_package_results = $package_service->listPopular();

    $popular_packages = array();
    
    foreach($popular_package_results as $package_result) {
        $popular_package = new Package(
            $package_result['id'],
            $package_result['name'],
            $package_result['url'],
            $package_result['thumbnail'],
            $package_result['description'],
            $package_result['category'],
            $package_result['popular'],
            $package_result['days'],
            $package_result['nights'],
            $package_result['location'],
            $package_result['starting_price'],
            $package_result['price_details'],
            $package_result['includes'],
            $package_result['excludes'],
            $package_result['altitude'],
            $package_result['level'],
            $package_result['group_size'],
            $package_result['accommodation'],
            $package_result['season'],
            $package_result['notes'],
            ""
        );
        array_push($popular_packages, $popular_package);
    }

    /* Event Section */

    $event_results = $event_service->list();

    $events = array();
    
    foreach($event_results as $event_result) {
        $event = new Event(
            $event_result['id'],
            $event_result['title'],
            $event_result['event_url'],
            $event_result['date'],
            $event_result['time'],
            $event_result['fee'],
            $event_result['description'],
            $event_result['venue'],
            $event_result['thumbnail'],
            $event_result['url'],
            $event_result['url_text']
        );
        array_push($events, $event);
    }

    /* events Section */
    
    /* Testimonial Section */

    $testimonial_result = $testimonial_service->listLimitTo(4);

    $testimonials = array();

    foreach($testimonial_result as $result) {
        $testimonial = new Testimonial(
            $result['id'],
            $result['full_name'],
            $result['position'],
            $result['company'],
            $result['image'],
            $result['quote']
        );
        array_push($testimonials, $testimonial);
    }

    /* Testimonial Section */
?>

