<?php
    include "config.php";
    include "../admin/models/Package.php";
    include "../admin/models/Image.php";
    include "../admin/models/ItineraryEntry.php";

    include "../admin/services/PackageService.php";
    include "../admin/services/ImageService.php";
    include "../admin/services/ItineraryEntryService.php";

    $package_service = new PackageService($db);
    $image_service = new ImageService($db);
    $itinerary_entry_service = new ItineraryEntryService($db);

    /* Packages Section */

    if (isset($_GET['url'])) {

        $result = $package_service->getByURL($_GET['url']);
        
        $package = new Package(
            $result['id'],
            $result['name'],
            $result['url'],
            $result['thumbnail'],
            $result['description'],
            $result['category'],
            $result['popular'],
            $result['days'],
            $result['nights'],
            $result['location'],
            $result['starting_price'],
            $result['price_details'],
            $result['includes'],
            $result['excludes'],
            $result['altitude'],
            $result['level'],
            $result['group_size'],
            $result['accommodation'],
            $result['season'],
            $result['notes'],
            ""
        );

        $itineraryExists = $itinerary_entry_service->itineraryExists($package->id);

        if ($itineraryExists) {
            $itinerary_result = $itinerary_entry_service->listByPackage($package->id);
    
            $itinerary = array();
            
            foreach ($itinerary_result as $result) {
                $itinerary_entry = new ItineraryEntry(
                    $result['id'],
                    $result['package'],
                    $result['day'],
                    $result['heading'],
                    $result['hour'],
                    $result['details']
                );
                array_push($itinerary, $itinerary_entry);
            }
        }
        $package_results = $package_service->listByLimitToExcept($package->id, 3);
    } else {
        $package_results = $package_service->list();
    }

    $packages = array();
    
    foreach($package_results as $package_result) {
        $other_package = new Package(
            $package_result['id'],
            $package_result['name'],
            $package_result['url'],
            $package_result['thumbnail'],
            $package_result['description'],
            $package_result['category'],
            $package_result['popular'],
            $package_result['days'],
            $package_result['nights'],
            $package_result['location'],
            $package_result['starting_price'],
            $package_result['price_details'],
            $package_result['includes'],
            $package_result['excludes'],
            $package_result['altitude'],
            $package_result['level'],
            $package_result['group_size'],
            $package_result['accommodation'],
            $package_result['season'],
            $package_result['notes'],
            ""
        );
        array_push($packages, $other_package);
    }

    /* Packages Section */

?>