<?php
    include "../../utils/Database.php";
    include "../../utils/functions.php";
    include "../../models/Author.php";
    include "../../models/Post.php";
    include "../../services/AuthorService.php";
    include "../../services/PostService.php";
?>

<?php

    notAccessibleToUser();

    $database = new Database();
    $db = $database->connect();

    $author_service = new AuthorService($db);
    $post_service = new PostService($db);

    if (isset($_POST['delete'])) {
        $action = 'delete';
    }

    switch($action) {
        case 'add':
            if(isset($_POST['add'])){
                $author = new Author(
                    0,
                    $_POST['full_name'],
                    $_POST['email']
                );
                
                $result = $author_service->add($author);
                if($result){
                    set_notification("New author added", "success");
                } else {
                    set_notification("Some error occurred", "error");
                }
                redirect("../author");
            }
            break;
        case 'view':
            $result = $author_service->get($_GET['id']);

            $author = new Author(
                $result['id'],
                $result['full_name'],
                $result['email']
            );

            $result_list = $post_service->listByAuthor($author->id);

            $posts_by_author = array();
            
            foreach($result_list as $result) {
                $post = new Post(
                    $result['id'],
                    $result['title'],
                    $result['url'],
                    $result['thumbnail'],
                    $result['author'],
                    $result['content'],
                    $result['created_at']
                );
                array_push($posts_by_author, $post);
            }

            break;
        case 'edit':
            if (isset($_POST['edit'])) {
                $author = new Author(
                    $_GET['id'],
                    $_POST['full_name'],
                    $_POST['email']
                );

                $result = $author_service->update($author);
                
                if($result){
                    set_notification("Author edited", "success");
                } else {
                    set_notification("Some error occurred", "error");
                }
                redirect("../view/" . $_GET['id']);
            } else {

                $result = $author_service->get($_GET['id']);

                $author = new Author(
                    $result['id'],
                    $result['full_name'],
                    $result['email']
                );
            }
            break;
        case 'list':
            $result_list = $author_service->list();
            
            $authors = array();
            
            foreach($result_list as $result) {
                $author = new Author(
                    $result['id'],
                    $result['full_name'],
                    $result['email']
                );
                array_push($authors, $author);
            }

            break;
        case 'delete':
            $object = $author_service->get($_POST['deleteId']);
                
            $author = new Author(
                $object['id'],
                $object['full_name'],
                $object['email']
            );

            if ($author) {
                $result = $author_service->delete($author);
                if($result){
                    set_notification("Author deleted", "success");
                } else {
                    set_notification("Some error occurred", "error");
                }
            }
            redirect("author");
            break;
        default:
            continue;
    }
?>