<?php
    include "../../utils/Database.php";
    include "../../utils/functions.php";
    include "../../models/Category.php";
    include "../../models/Package.php";
    include "../../services/CategoryService.php";
    include "../../services/PackageService.php";
?>

<?php

    $database = new Database();
    $db = $database->connect();

    $category_service = new CategoryService($db);
    $package_service = new PackageService($db);

    if (isset($_POST['delete'])) {
        $action = 'delete';
    }

    switch($action) {
        case 'add':
            if(isset($_POST['add'])){
                $category = new Category(
                    0,
                    $_POST['category']
                );
                
                $result = $category_service->add($category);
                if($result){
                    set_notification("New category added", "success");
                } else {
                    set_notification("Some error occurred", "error");
                }
                redirect("../category");
            }
            break;
        case 'view':
            $result = $category_service->get($_GET['id']);

            $category = new Category(
                $result['id'],
                $result['category']
            );

            $result_list = $package_service->listByCategory($category->id);

            $package_in_category = array();
            
            foreach($result_list as $result) {
                $package = new Package(
                    $result['id'],
                    $result['name'],
                    $result['url'],
                    $result['thumbnail'],
                    $result['description'],
                    $result['category'],
                    $result['popular'],
                    $result['days'],
                    $result['nights'],
                    $result['location'],
                    $result['starting_price'],
                    $result['price_details'],
                    $result['includes'],
                    $result['excludes'],
                    $result['altitude'],
                    $result['level'],
                    $result['group_size'],
                    $result['accommodation'],
                    $result['season'],
                    $result['notes'],
                    $result['created_at']
                );
                array_push($package_in_category, $package);
            }

            break;
        case 'edit':
            if (isset($_POST['edit'])) {
                $category = new Category(
                    $_GET['id'],
                    $_POST['category']
                );

                $result = $category_service->update($category);
                
                if($result){
                    set_notification("Category edited", "success");
                } else {
                    set_notification("Some error occurred", "error");
                }
                redirect("../view/" . $_GET['id']);
            } else {

                $result = $category_service->get($_GET['id']);

                $category = new Category(
                    $result['id'],
                    $result['category']
                );
            }
            break;
        case 'list':
            $result_list = $category_service->list();
            
            $categories = array();
            
            foreach($result_list as $result) {
                $category = new Category(
                    $result['id'],
                    $result['category']
                );
                array_push($categories, $category);
            }

            break;
        case 'delete':
            $object = $category_service->get($_POST['deleteId']);
                
            $category = new Category(
                $object['id'],
                $object['category']
            );
            if ($category) {
                $result = $category_service->delete($category);
                if($result){
                    set_notification("Category deleted", "success");
                } else {
                    set_notification("Some error occurred", "error");
                }
            }
            redirect("category");
            break;
        default:
            continue;
    }
?>