<?php
    include "../../utils/Database.php";
    include "../../utils/functions.php";
    include "../../models/GalleryImage.php";
    include "../../models/Image.php";
    include "../../services/GalleryImageService.php";
    include "../../services/ImageService.php";
?>

<?php

    $database = new Database();
    $db = $database->connect();

    $gallery_service = new GalleryImageService($db);
    $image_service = new ImageService($db);
    
    if (isset($_POST['delete'])) {
        $action = 'delete';
    }
    
    switch($action) {
        case 'add':
            if (isset($_POST['add'])) {
                $new_image = new Image(0, $_POST['caption'], $_FILES['fileToUpload']['name']);
                $image_service->add($new_image);
                
                $result_list = $image_service->getLatest();
                foreach($result_list as $result) {
                    $image = new Image(
                        $result['id'],
                        $result['caption'],
                        $result['filename']
                    );
                }

                $gallery_image = new GalleryImage(
                    0,
                    $_POST['caption'],
                    $image->id
                );

                if (upload_file($_FILES, 'images')) {
                    $result = $gallery_service->add($gallery_image);
                    if($result){
                        set_notification("Gallery Image added", "success");
                    } else {
                        set_notification("Some error occurred", "error");
                    }
                }
                redirect("../gallery");
            }
            break;
        case 'edit':
            if (isset($_POST['edit'])) {

                if ($_FILES['fileToUpload']['name'] == "") {
                    $get_image = $image_service->get($_POST['oldImage']);
                    $image = new Image(
                        $get_image['id'],
                        $get_image['caption'],
                        $get_image['filename']
                    );

                    $gallery_image = new GalleryImage(
                        $_GET['id'],
                        $_POST['caption'],
                        $image->id
                    );
                    $result = $gallery_service->update($gallery_image);
                    
                    if($result){
                        set_notification("Gallery image edited", "success");
                    } else {
                        set_notification("Some error occurred", "error");
                    }
                } else {
                    $new_image = new Image(0, $_POST['caption'], $_FILES['fileToUpload']['name']);
                    $image_service->add($new_image);
                    
                    $result_list = $image_service->getLatest();
                    foreach($result_list as $result) {
                        $image = new Image(
                            $result['id'],
                            $result['caption'],
                            $result['filename']
                        );
                    }

                    $gallery_image = new GalleryImage(
                        $_GET['id'],
                        $_POST['caption'],
                        $image->id
                    );

                    if (upload_file($_FILES, 'images')) {
                        $result = $gallery_service->update($gallery_image);
                        if($result){
                            set_notification("Gallery image edited", "success");
                        } else {
                            set_notification("Some error occurred", "error");
                        }
                    }
                }
            } else {
                
                $result = $gallery_service->get($_GET['id']);

                $gallery_image = new GalleryImage(
                    $result['id'],
                    $result['caption'],
                    $result['image']
                );

                $object = $image_service->get($gallery_image->image);
                $image = new Image(
                    $object['id'],
                    $object['caption'],
                    $object['filename']
                );
            }
            break;
        case 'list':
            $result_list = $gallery_service->list();
            
            $gallery_images = array();
            
            foreach($result_list as $result) {
                $gallery_image = new GalleryImage(
                    $result['id'],
                    $result['caption'],
                    $result['image']
                );
                array_push($gallery_images, $gallery_image);
            }

            break;
        case 'delete':
            $result = $gallery_service->get($_POST['deleteId']);
                
            $gallery_image = new GalleryImage(
                $result['id'],
                $result['caption'],
                $result['image']
            );

            if ($gallery_image) {
                $result = $gallery_service->delete($gallery_image);
                if($result){
                    set_notification("Image deleted", "success");
                } else {
                    set_notification("Some error occurred", "error");
                }
            }
            redirect("gallery");
            break;
        default:
            continue;
    }
?>