<?php
    include "../../utils/Database.php";
    include "../../utils/functions.php";
    include "../../models/Package.php";
    include "../../models/ItineraryEntry.php";
    include "../../services/PackageService.php";
    include "../../services/ItineraryEntryService.php";

    $database = new Database();
    $db = $database->connect();

    $package_service = new PackageService($db);
    $itinerary_entry_service = new ItineraryEntryService($db);

    $itineraryExists = $itinerary_entry_service->itineraryExists($_GET['id']);

    $result = $package_service->get($_GET['id']);

    $package = new Package(
        $result['id'],
        $result['name'],
        $result['url'],
        $result['thumbnail'],
        $result['description'],
        $result['category'],
        $result['popular'],
        $result['days'],
        $result['nights'],
        $result['location'],
        $result['starting_price'],
        $result['price_details'],
        $result['includes'],
        $result['excludes'],
        $result['altitude'],
        $result['level'],
        $result['group_size'],
        $result['accommodation'],
        $result['season'],
        $result['notes'],
        $result['created_at']
    );

    if (isset($_POST['add'])) {

        $headings = $_POST['heading'];
        $hours = $_POST['hour'];
        $details = $_POST['detail'];

        array_unshift($headings,"");
        unset($headings[0]);
        array_unshift($hours,"");
        unset($hours[0]);
        array_unshift($details,"");
        unset($details[0]);

        $flag = 0;

        for ($index = 1; $index <= count($headings); $index++) {
            $itinerary_entry = new ItineraryEntry(
                0,
                $package->id,
                $index,
                $headings[$index],
                $hours[$index],
                $details[$index]
            );
        
            if ($itinerary_entry_service->add($itinerary_entry)){
                $flag = 1;
            } else {
                $flag = 0;
            }
        }
        
        if($flag){
            set_notification("Itinerary added", "success");
        } else {
            set_notification("Some error occurred", "error");
        }

        redirect("../package");
    }


    if (isset($_POST['edit'])) {

        $ids = $_POST['id'];
        $headings = $_POST['heading'];
        $hours = $_POST['hour'];
        $details = $_POST['detail'];

        array_unshift($ids,"");
        unset($ids[0]);
        array_unshift($headings,"");
        unset($headings[0]);
        array_unshift($hours,"");
        unset($hours[0]);
        array_unshift($details,"");
        unset($details[0]);

        $flag = 0;

        for ($index = 1; $index <= count($headings); $index++) {
            $itinerary_entry = new ItineraryEntry(
                $ids[$index],
                $package->id,
                $index,
                $headings[$index],
                $hours[$index],
                $details[$index]
            );
            
            if ($itinerary_entry_service->update($itinerary_entry)){
                $flag = 1;
            } else {
                $flag = 0;
            }
        }

        if($flag){
            set_notification("Itinerary edited", "success");
        } else {
            set_notification("Some error occurred", "error");
        }

    }

    if ($itineraryExists) {
        $itinerary_result = $itinerary_entry_service->listByPackage($_GET['id']);

        $itinerary = array();
        
        foreach ($itinerary_result as $result) {
            $itinerary_entry = new ItineraryEntry(
                $result['id'],
                $result['package'],
                $result['day'],
                $result['heading'],
                $result['hour'],
                $result['details']
            );
            array_push($itinerary, $itinerary_entry);
        }

        array_unshift($itinerary,"");
        unset($itinerary[0]);
    }
?>