<?php
    include "../../utils/Database.php";
    include "../../utils/functions.php";
    include "../../models/Post.php";
    include "../../models/Image.php";
    include "../../models/Author.php";
    include "../../services/PostService.php";
    include "../../services/ImageService.php";
    include "../../services/AuthorService.php";
?>

<?php

    $database = new Database();
    $db = $database->connect();
    $image_service = new ImageService($db);

    $post_service = new PostService($db);
    $author_service = new AuthorService($db);

    if (isset($_POST['delete'])) {
        $action = 'delete';
    }
    switch($action) {
        case 'add':
            $author_list = $author_service->list();
            
            $authors = array();
            
            foreach($author_list as $result) {
                $author = new Author(
                        $result['id'],
                        $result['full_name'],
                        $result['email']
                    );
                array_push($authors, $author);
            }

            if(isset($_POST['add'])){

                $unique_post = $post_service->isUnique($_POST['title']);
                
                if ($unique_post) {
                    set_notification("A post with same title already exists","error");
                } else {
                    $new_image = new Image(0, $_POST['title'], $_FILES['fileToUpload']['name']);
                    $image_service->add($new_image);
                    $result_list = $image_service->getLatest();

                    foreach($result_list as $result) {
                        $image = new Image(
                            $result['id'],
                            $result['caption'],
                            $result['filename']
                        );
                    }

                    $post = new Post(
                        0,
                        $_POST['title'],
                        getFormattedName($_POST['title']),
                        $image->id,
                        $_POST['author'],
                        $_POST['content'],
                        date('Y-m-d H:i:s')
                    );
                    
                    if (upload_file($_FILES, 'images')) {
                        $result = $post_service->add($post);

                        if($result){
                            set_notification("New post added", "success");
                        } else {
                            set_notification("Some error occurred", "error");
                        }
                    }
                }
                redirect("../blog");
            }
            break;
        case 'view':
            $result = $post_service->get($_GET['id']);

            $post = new Post(
                $result['id'],
                $result['title'],
                $result['url'],
                $result['thumbnail'],
                $result['author'],
                $result['content']
            );

            $object = $author_service->get($post->author);

            $author = new Author(
                $object['id'],
                $object['full_name'],
                $object['email']
            );

            $object3 = $image_service->get($post->thumbnail);
            $image = new Image(
                $object3['id'],
                $object3['caption'],
                $object3['filename']
            );

            break;
        case 'edit':
            if (isset($_POST['edit'])) {

                if ($_FILES['fileToUpload']['name'] == "") {
                    $get_image = $image_service->get($_POST['oldImage']);
                    $image = new Image(
                        $get_image['id'],
                        $get_image['caption'],
                        $get_image['filename']
                    );

                    $post = new Post(
                        $_GET['id'],
                        $_POST['title'],
                        getFormattedName($_POST['title']),
                        $image->id,
                        $_POST['author'],
                        $_POST['content'],
                        ""
                    );

                    $result = $post_service->update($post);
                    if($result){
                        set_notification("Post edited", "success");
                    } else {
                        set_notification("Some error occurred", "error");
                    }
                } else {
                    $new_image = new Image(0, $_POST['title'], $_FILES['fileToUpload']['name']);
                    $image_service->add($new_image);
                    
                    $result_list = $image_service->getLatest();
                    foreach($result_list as $result) {
                        $image = new Image(
                            $result['id'],
                            $result['caption'],
                            $result['filename']
                        );
                    }

                    $post = new Post(
                        $_GET['id'],
                        $_POST['title'],
                        getFormattedName($_POST['title']),
                        $image->id,
                        $_POST['author'],
                        $_POST['content'],
                        ""
                    );
    
                    if (upload_file($_FILES, 'images')) {
                        $result = $post_service->update($post);
                        if($result){
                            set_notification("Post edited", "success");
                        } else {
                            set_notification("Some error occurred", "error");
                        }
                    }
                }
                $author_list = $author_service->list();
            
                $authors = array();
                
                foreach($author_list as $result) {
                    $author = new Author(
                        $result['id'],
                        $result['full_name'],
                        $result['email']
                    );
                    array_push($authors, $author);
                }

                $object = $author_service->get($post->author);

                $selectedAuthor = new Author(
                    $object['id'],
                    $object['full_name'],
                    $object['email']
                );
            } else {
                $author_list = $author_service->list();
            
                $authors = array();
                
                foreach($author_list as $result) {
                    $author = new Author(
                        $result['id'],
                        $result['full_name'],
                        $result['email']
                    );
                    array_push($authors, $author);
                }

                $result = $post_service->get($_GET['id']);

                $post = new Post(
                    $result['id'],
                    $result['title'],
                    $result['url'],
                    $result['thumbnail'],
                    $result['author'],
                    $result['content'],
                    $result['created_at']
                );

                $object = $author_service->get($post->author);

                $selectedAuthor = new Author(
                    $object['id'],
                    $object['full_name'],
                    $object['email']
                );

                $object3 = $image_service->get($post->thumbnail);
                $image = new Image(
                    $object3['id'],
                    $object3['caption'],
                    $object3['filename']
                );
            }
            break;
        case 'list':
            $result_list = $post_service->list();
            
            $posts = array();

            foreach($result_list as $result) {
                    $post = new Post(
                        $result['id'],
                        $result['title'],
                        $result['url'],
                        $result['thumbnail'],
                        $result['author'],
                        $result['content'],
                        $result['created_at']
                    );
                    array_push($posts, $post);
            }
            break;
        case 'delete':
            $object = $post_service->get($_POST['deleteId']);
                
            $post = new Post(
                $object['id'],
                $object['title'],
                $object['url'],
                $object['thumbnail'],
                $object['author'],
                $object['content'],
                $object['created_at']
            );
            if ($post) {
                $result = $post_service->delete($post);
                if($result){
                    set_notification("Post deleted","success");
                } else {
                    set_notification("Some error occurred","error");
                }
            }
            redirect("blog");
            break;
        default:
            continue;
    }
?>