<?php

class AboutService {

    private $conn;
    private $table = "about";
    
    public function __construct($db) {
        $this->conn = $db;
    }

    public function update($about) {

        $query = "UPDATE " . $this->table . 
            " SET image = :image, 
                description = :description, 
                content = :content
              WHERE id = 1";
        
        $stmt = $this->conn->prepare($query);
        
        $about->image = htmlspecialchars(strip_tags($about->image));

        $stmt->bindParam(':image', $about->image);
        $stmt->bindParam(':description', $about->description);
        $stmt->bindParam(':content', $about->content);
        
        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }


    public function get() {

        $query = "SELECT * FROM " . $this->table . " WHERE id = 1";

        $stmt = $this->conn->prepare($query);
        $stmt->execute();

        return ($stmt->fetch(PDO::FETCH_ASSOC));
    }
}

?>