<?php

class SliderService {

    private $conn;
    private $table = "slider";
    
    public function __construct($db) {
        $this->conn = $db;
    }

    public function update($slider) {

        $query = "UPDATE " . $this->table . 
            " SET title = :title, 
                subheading = :subheading, 
                image = :image
              WHERE id = :id";
        
        $stmt = $this->conn->prepare($query);
        
        $slider->title = htmlspecialchars(strip_tags($slider->title));
        $slider->subheading = htmlspecialchars(strip_tags($slider->subheading));
        $slider->image = htmlspecialchars(strip_tags($slider->image));

        $stmt->bindParam(':title', $slider->title);
        $stmt->bindParam(':subheading', $slider->subheading);
        $stmt->bindParam(':image', $slider->image);
        $stmt->bindParam(':id', $slider->id);

        if($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }


    public function list() {

        $query = "SELECT * FROM " . $this->table;

        $stmt = $this->conn->prepare($query);
        $stmt->execute();

        $result_list = array();

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {       
            array_push($result_list, $row);
        }
        return $result_list;
    }

    public function get($id) {

        $query = "SELECT * FROM " . $this->table . " WHERE id = :id";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();

        return ($stmt->fetch(PDO::FETCH_ASSOC));
    }
}

?>