<div class="container-fluid">
    <div class="row pb-3">
        <div class="col-md-2 col-sm-12 offset-md-1">
            <h3 class="wln-text-purple package-header">EVENTS</h3>
            <hr style="border: solid 2px #d66325; "/>
        </div>
    </div>
    <div class="row">
        <div class="col-md-11 col-sm-12 offset-md-1">
            <div class="card-deck owl-carousel owl-theme" id="sliding-cards-events">
                <?php foreach ($events as $event) { ?>
                <div class="card wln-white-light img-box shadow-sm">
                    <?php 
                        $image_result = $image_service->get($event->thumbnail);
                        $image = new Image(
                            $image_result['id'],
                            $image_result['caption'],
                            $image_result['filename']
                        ); 
                    ?>
                    <img src="assets/images/<?php echo $image->filename; ?>" class="card-img-top img-fluid" alt="<?php echo $image->caption; ?>">
                    <div class="card-body pl-4 pr-0">
                        <h5 class="card-title wln-text-purple"><?php echo $event->title; ?></h5>
                        <p>
                            <i class="fas fa-calendar-alt mr-2 wln-text-orange"></i>
                            <?php echo date_format(date_create($event->date), "M d, Y"); ?>
                        </p>
                        <p>
                            <i class="fas fa-map-marker-alt mr-2 wln-text-orange"></i>
                            <?php echo $event->venue; ?>
                        </p>
                    </div>
                    <div class="card-footer wln-white-light text-center">
                        <a href="events/<?php echo $event->event_url; ?>" class="btn btn-outline-purple wln-white-light wln-text-purple rounded-0 px-5"> VIEW </a>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>